/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom;

import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.ItemCollectionSerializer;
import net.shibboleth.metadata.ItemSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

@ThreadSafe
public class DOMElementSerializer
implements ItemSerializer<Element>,
ItemCollectionSerializer<Element> {
    private final Logger log = LoggerFactory.getLogger(DOMElementSerializer.class);

    @Override
    public void serialize(@Nonnull Item<Element> item, @Nonnull OutputStream output) {
        if (item == null) {
            return;
        }
        Element documentRoot = item.unwrap();
        try {
            TransformerFactory tfac = TransformerFactory.newInstance();
            Transformer serializer = tfac.newTransformer();
            serializer.setOutputProperty("encoding", "UTF-8");
            serializer.transform(new DOMSource(documentRoot.getOwnerDocument()), new StreamResult(output));
        }
        catch (TransformerException e) {
            this.log.error("Unable to write out XML", (Throwable)e);
        }
    }

    @Override
    public void serializeCollection(@Nonnull Collection<Item<Element>> items, @Nonnull OutputStream output) {
        Iterator<Item<Element>> iter = items.iterator();
        if (iter.hasNext()) {
            this.serialize(iter.next(), output);
            if (iter.hasNext()) {
                this.log.warn("collection contained more than one Item; rest ignored");
            }
        } else {
            this.log.warn("collection was empty");
        }
    }
}

