/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.dom.DOMElementItem;
import net.shibboleth.metadata.pipeline.BaseStage;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.xml.ParserPool;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.w3c.dom.Element;

@ThreadSafe
public class DOMResourceSourceStage
extends BaseStage<Element> {
    private final Logger log = LoggerFactory.getLogger(DOMResourceSourceStage.class);
    private Resource domResource;
    private ParserPool parserPool;
    private boolean errorCausesSourceFailure = true;

    @Nullable
    public Resource getDOMResource() {
        return this.domResource;
    }

    public synchronized void setDOMResource(@Nonnull Resource resource) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.domResource = (Resource)Constraint.isNotNull((Object)resource, (String)"DOM resource can not be null");
    }

    @Nullable
    public ParserPool getParserPool() {
        return this.parserPool;
    }

    public synchronized void setParserPool(@Nonnull ParserPool pool) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.parserPool = (ParserPool)Constraint.isNotNull((Object)pool, (String)"Parser pool can not be null");
    }

    public boolean getErrorCausesSourceFailure() {
        return this.errorCausesSourceFailure;
    }

    public synchronized void setErrorCausesSourceFailure(boolean causesFailure) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.errorCausesSourceFailure = causesFailure;
    }

    @Override
    protected void doExecute(@Nonnull @NonnullElements Collection<Item<Element>> itemCollection) throws StageProcessingException {
        this.log.debug("Attempting to fetch XML document from '{}'", (Object)this.domResource.getDescription());
        try (InputStream ins = this.domResource.getInputStream();){
            this.populateItemCollection(itemCollection, ins);
        }
        catch (IOException e) {
            if (this.errorCausesSourceFailure) {
                throw new StageProcessingException("Error retrieving XML document from " + this.domResource.getDescription(), e);
            }
            this.log.warn("stage {}: unable to read in XML file", (Object)this.getId());
            this.log.debug("stage {}: HTTP resource exception", (Object)this.getId(), (Object)e);
        }
    }

    protected void populateItemCollection(@Nonnull @NonnullElements Collection<Item<Element>> itemCollection, InputStream data) throws StageProcessingException {
        try {
            this.log.debug("Parsing XML document retrieved from '{}'", (Object)this.domResource.getDescription());
            itemCollection.add(new DOMElementItem(this.parserPool.parse(data)));
        }
        catch (XMLParserException e) {
            if (this.errorCausesSourceFailure) {
                throw new StageProcessingException(this.getId() + " unable to parse returned XML document " + this.domResource.getDescription(), (Exception)((Object)e));
            }
            this.log.warn("stage {}: unable to parse XML document", (Object)this.getId());
            this.log.debug("stage {}: parsing exception", (Object)this.getId(), (Object)e);
        }
    }

    protected void doDestroy() {
        this.domResource = null;
        this.parserPool = null;
        super.doDestroy();
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.parserPool == null) {
            throw new ComponentInitializationException("Unable to initialize " + this.getId() + ", ParserPool may not be null");
        }
        if (this.domResource == null) {
            throw new ComponentInitializationException("Unable to initialize " + this.getId() + ", either a DomResource must be specified");
        }
        if (!this.domResource.exists()) {
            throw new ComponentInitializationException("Unable to initialize " + this.getId() + ", DOM resource " + this.domResource.getDescription() + " does not exist");
        }
    }
}

