/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom;

import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.pipeline.BaseStage;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.xml.ElementSupport;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@ThreadSafe
public class EmptyContainerStrippingStage
extends BaseStage<Element> {
    private String elementNamespace;
    private String elementName;

    @Nullable
    public String getElementNamespace() {
        return this.elementNamespace;
    }

    public void setElementNamespace(@Nonnull @NotEmpty String namespace) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.elementNamespace = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)namespace), (String)"target namespace can not be null or empty");
    }

    @Nullable
    public String getElementName() {
        return this.elementName;
    }

    public void setElementName(@Nonnull @NotEmpty String name) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.elementName = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)name), (String)"target element name can not be null or empty");
    }

    private boolean hasChildElements(@Nonnull Element element) {
        Element firstChild = ElementSupport.getFirstChildElement((Node)((Node)Constraint.isNotNull((Object)element, (String)"Element can not be null")));
        return firstChild != null;
    }

    @Override
    protected void doExecute(@Nonnull @NonnullElements Collection<Item<Element>> items) throws StageProcessingException {
        for (Item<Element> item : items) {
            Element element = item.unwrap();
            NodeList extensionList = element.getElementsByTagNameNS(this.elementNamespace, this.elementName);
            for (int eIndex = extensionList.getLength() - 1; eIndex >= 0; --eIndex) {
                Element extensions = (Element)extensionList.item(eIndex);
                if (this.hasChildElements(extensions)) continue;
                extensions.getParentNode().removeChild(extensions);
            }
        }
    }

    protected void doDestroy() {
        this.elementNamespace = null;
        this.elementName = null;
        super.doDestroy();
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.elementNamespace == null) {
            throw new ComponentInitializationException("target namespace can not be null or empty");
        }
        if (this.elementName == null) {
            throw new ComponentInitializationException("target element name can not be null or empty");
        }
    }
}

