/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.dom.AbstractXSLProcessingStage;
import net.shibboleth.metadata.dom.DOMElementItem;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import net.shibboleth.metadata.util.ItemMetadataSupport;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.xml.ElementSupport;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@ThreadSafe
public class MultiOutputXSLTransformationStage
extends AbstractXSLProcessingStage {
    @Override
    protected void executeTransformer(@Nonnull Transformer transformer, @Nonnull @NonnullElements Collection<Item<Element>> itemCollection) throws StageProcessingException, TransformerConfigurationException {
        try {
            ArrayList<DOMElementItem> newItems = new ArrayList<DOMElementItem>();
            for (Item<Element> domItem : itemCollection) {
                transformer.setErrorListener(new AbstractXSLProcessingStage.StatusInfoAppendingErrorListener(domItem));
                Element element = domItem.unwrap();
                DOMResult result = new DOMResult(element.getOwnerDocument().createDocumentFragment());
                transformer.transform(new DOMSource(element.getOwnerDocument()), result);
                List transformedElements = ElementSupport.getChildElements((Node)result.getNode());
                for (Element transformedElement : transformedElements) {
                    DOMElementItem newItem = new DOMElementItem(transformedElement);
                    ItemMetadataSupport.addAll(newItem, domItem.getItemMetadata().values());
                    newItems.add(newItem);
                }
            }
            itemCollection.clear();
            itemCollection.addAll(newItems);
        }
        catch (TransformerException e) {
            throw new StageProcessingException("Unable to transform DOM Element", e);
        }
    }
}

