/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.metadata.dom.AbstractNamespacesStrippingStage;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;

@ThreadSafe
public class NamespaceStrippingStage
extends AbstractNamespacesStrippingStage {
    private String namespace;

    @Nullable
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(@Nonnull @NotEmpty String ns) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.namespace = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)ns), (String)"target namespace can not be null or empty");
    }

    @Override
    protected boolean removingNamespace(String ns) {
        return this.namespace.equals(ns);
    }

    protected void doDestroy() {
        this.namespace = null;
        super.doDestroy();
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.namespace == null) {
            throw new ComponentInitializationException("target namespace can not be null or empty");
        }
    }
}

