/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.metadata.dom.AbstractNamespacesStrippingStage;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;

@ThreadSafe
public class NamespacesStrippingStage
extends AbstractNamespacesStrippingStage {
    private final Set<String> namespaces = new HashSet<String>();
    private boolean whitelisting;

    @Nonnull
    public Collection<String> getNamespaces() {
        HashSet<String> result = new HashSet<String>();
        result.addAll(this.namespaces);
        return result;
    }

    public void setNamespaces(@Nonnull Collection<String> nss) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.namespaces.clear();
        this.namespaces.addAll(nss);
    }

    public boolean isWhitelisting() {
        return this.whitelisting;
    }

    public void setWhitelisting(boolean wl) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.whitelisting = wl;
    }

    @Override
    protected boolean removingNamespace(String namespace) {
        return this.whitelisting ^ this.namespaces.contains(namespace);
    }

    protected void doDestroy() {
        this.namespaces.clear();
        super.doDestroy();
    }
}

