/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom;

import com.google.common.collect.ImmutableSet;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.metadata.ErrorStatus;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.WarningStatus;
import net.shibboleth.metadata.dom.XMLSignatureValidator;
import net.shibboleth.metadata.pipeline.BaseIteratingStage;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.xml.SerializeSupport;
import org.apache.xml.security.Init;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@ThreadSafe
public class XMLSignatureValidationStage
extends BaseIteratingStage<Element> {
    private final Logger log = LoggerFactory.getLogger(XMLSignatureValidationStage.class);
    private boolean signatureRequired = true;
    private boolean validSignatureRequired = true;
    private Certificate verificationCertificate;
    private PublicKey verificationKey;
    @Nonnull
    private Set<String> blacklistedDigests = Collections.emptySet();
    @Nonnull
    private Set<String> blacklistedSignatureMethods = Collections.emptySet();
    private boolean permittingEmptyReferences = true;
    private XMLSignatureValidator validator;

    public boolean isSignatureRequired() {
        return this.signatureRequired;
    }

    public synchronized void setSignatureRequired(boolean required) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.signatureRequired = required;
    }

    public boolean isValidSignatureRequired() {
        return this.validSignatureRequired;
    }

    public synchronized void setValidSignatureRequired(boolean isRequired) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.validSignatureRequired = isRequired;
    }

    @Nullable
    public PublicKey getVerificationKey() {
        return this.verificationKey;
    }

    public synchronized void setVerificationKey(@Nonnull PublicKey key) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.verificationKey = (PublicKey)Constraint.isNotNull((Object)key, (String)"Public key can not be null");
    }

    @Nullable
    public Certificate getVerificationCertificate() {
        return this.verificationCertificate;
    }

    public synchronized void setVerificationCertificate(@Nonnull Certificate certificate) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.verificationCertificate = (Certificate)Constraint.isNotNull((Object)certificate, (String)"Certificate can not be null");
        this.verificationKey = this.verificationCertificate.getPublicKey();
    }

    public void setBlacklistedDigests(@Nonnull @NonnullElements Collection<String> identifiers) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.blacklistedDigests = ImmutableSet.copyOf((Collection)((Collection)Constraint.isNotNull(identifiers, (String)"identifier collection may not be null")));
    }

    @Nonnull
    @NonnullElements
    public Set<String> getBlacklistedDigests() {
        return Collections.unmodifiableSet(this.blacklistedDigests);
    }

    public void setBlacklistedSignatureMethods(@Nonnull @NonnullElements Collection<String> identifiers) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.blacklistedSignatureMethods = ImmutableSet.copyOf((Collection)((Collection)Constraint.isNotNull(identifiers, (String)"identifier collection may not be null")));
    }

    @Nonnull
    @NonnullElements
    public Set<String> getBlacklistedSignatureMethods() {
        return Collections.unmodifiableSet(this.blacklistedSignatureMethods);
    }

    public boolean isPermittingEmptyReferences() {
        return this.permittingEmptyReferences;
    }

    public synchronized void setPermittingEmptyReferences(boolean permit) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.permittingEmptyReferences = permit;
    }

    @Override
    protected boolean doExecute(@Nonnull Item<Element> item) throws StageProcessingException {
        Element signatureElement;
        Element docElement = item.unwrap();
        try {
            signatureElement = this.validator.getSignatureElement(docElement);
            if (signatureElement == null) {
                if (this.signatureRequired) {
                    this.log.debug("DOM Element was not signed and signature is required");
                    item.getItemMetadata().put((Object)new ErrorStatus(this.getId(), "DOM Element was not signed but signatures are required"));
                } else {
                    this.log.debug("DOM Element is not signed, no verification performed");
                }
                return true;
            }
        }
        catch (XMLSignatureValidator.ValidationException e) {
            this.log.debug("setting status: ", (Object)e.getMessage());
            item.getItemMetadata().put((Object)new ErrorStatus(this.getId(), e.getMessage()));
            return true;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("DOM Element contained Signature element\n{}", (Object)SerializeSupport.prettyPrintXML((Node)signatureElement));
        }
        try {
            this.validator.verifySignature(docElement, signatureElement);
        }
        catch (XMLSignatureValidator.ValidationException e) {
            String message = "element signature is invalid: " + e.getMessage();
            this.log.debug("setting status: ", (Object)message);
            if (this.validSignatureRequired) {
                item.getItemMetadata().put((Object)new ErrorStatus(this.getId(), message));
            }
            item.getItemMetadata().put((Object)new WarningStatus(this.getId(), message));
        }
        return true;
    }

    protected void doDestroy() {
        this.verificationCertificate = null;
        this.verificationKey = null;
        this.validator = null;
        this.blacklistedDigests = null;
        this.blacklistedSignatureMethods = null;
        super.doDestroy();
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.verificationKey == null) {
            throw new ComponentInitializationException("Unable to initialize " + this.getId() + ", no verification key was specified");
        }
        this.validator = new XMLSignatureValidator(this.verificationKey, this.blacklistedDigests, this.blacklistedSignatureMethods, this.permittingEmptyReferences);
        if (!Init.isInitialized()) {
            Init.init();
        }
    }
}

