/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom;

import java.util.Collection;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.pipeline.BaseStage;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.xml.SimpleNamespaceContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

@ThreadSafe
public class XPathFilteringStage
extends BaseStage<Element> {
    private final Logger log = LoggerFactory.getLogger(XPathFilteringStage.class);
    private String xpathExpression;
    private NamespaceContext namespaceContext = new SimpleNamespaceContext();

    @Nullable
    public String getXPathExpression() {
        return this.xpathExpression;
    }

    public synchronized void setXPathExpression(@Nonnull @NotEmpty String expression) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.xpathExpression = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)expression), (String)"XPath expression can not be null or empty");
    }

    @Nonnull
    public NamespaceContext getNamespaceContext() {
        return this.namespaceContext;
    }

    public synchronized void setNamespaceContext(@Nullable NamespaceContext context) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.namespaceContext = context == null ? new SimpleNamespaceContext() : context;
    }

    @Override
    public void doExecute(@Nonnull @NonnullElements Collection<Item<Element>> metadataCollection) {
        XPathExpression compiledExpression;
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        if (this.namespaceContext != null) {
            xpath.setNamespaceContext(this.namespaceContext);
        }
        try {
            compiledExpression = xpath.compile(this.xpathExpression);
        }
        catch (XPathExpressionException e) {
            this.log.error("error compiling XPath expression; no filtering performed", (Throwable)e);
            return;
        }
        Iterator<Item<Element>> iterator = metadataCollection.iterator();
        while (iterator.hasNext()) {
            Item<Element> item = iterator.next();
            try {
                Boolean filterThis = (Boolean)compiledExpression.evaluate(item.unwrap(), XPathConstants.BOOLEAN);
                if (!filterThis.booleanValue()) continue;
                this.log.debug("removing item matching XPath condition");
                iterator.remove();
            }
            catch (XPathExpressionException e) {
                this.log.error("removing item due to XPath expression error", (Throwable)e);
                iterator.remove();
            }
        }
    }

    protected void doDestroy() {
        this.xpathExpression = null;
        this.namespaceContext = null;
        super.doDestroy();
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.xpathExpression == null) {
            throw new ComponentInitializationException("XPath expression can not be null or empty");
        }
    }
}

