/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom;

import com.google.common.base.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import net.shibboleth.metadata.Item;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.xml.SimpleNamespaceContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

@ThreadSafe
public class XPathItemSelectionStrategy
implements Predicate<Item<Element>> {
    private final Logger log = LoggerFactory.getLogger(XPathItemSelectionStrategy.class);
    private final XPathExpression compiledExpression;
    private final NamespaceContext namespaceContext;

    public XPathItemSelectionStrategy(@Nonnull @NotEmpty String expression, @Nonnull NamespaceContext context) throws XPathExpressionException {
        this.namespaceContext = context == null ? new SimpleNamespaceContext() : context;
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        if (this.namespaceContext != null) {
            xpath.setNamespaceContext(this.namespaceContext);
        }
        this.compiledExpression = xpath.compile(expression);
    }

    public synchronized boolean apply(@Nonnull Item<Element> item) {
        try {
            return (Boolean)this.compiledExpression.evaluate(item.unwrap(), XPathConstants.BOOLEAN);
        }
        catch (XPathExpressionException e) {
            this.log.warn("Exception thrown during XPath evaluation: " + e);
            return false;
        }
    }
}

