/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom.ds;

import java.io.ByteArrayInputStream;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.annotation.Nonnull;
import net.shibboleth.metadata.ErrorStatus;
import net.shibboleth.metadata.dom.AbstractDOMTraversalStage;
import net.shibboleth.metadata.dom.AbstractDOMValidationStage;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import net.shibboleth.utilities.java.support.codec.Base64Support;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.w3c.dom.Element;

public class X509ValidationStage
extends AbstractDOMValidationStage<X509Certificate> {
    private CertificateFactory factory;

    @Override
    protected boolean applicable(@Nonnull Element e) {
        return "http://www.w3.org/2000/09/xmldsig#".equals(e.getNamespaceURI()) && "X509Certificate".equals(e.getLocalName());
    }

    @Override
    protected void visit(@Nonnull Element element, @Nonnull AbstractDOMTraversalStage.TraversalContext context) throws StageProcessingException {
        String text = element.getTextContent();
        byte[] data = Base64Support.decode((String)text);
        try {
            X509Certificate cert = (X509Certificate)this.factory.generateCertificate(new ByteArrayInputStream(data));
            if (!context.getStash().containsValue((Object)cert)) {
                context.getStash().put((Object)cert);
                this.applyValidators(cert, context);
            }
        }
        catch (CertificateException e) {
            context.getItem().getItemMetadata().put((Object)new ErrorStatus(this.getId(), "could not convert X509Certificate data"));
        }
    }

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        try {
            this.factory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            throw new ComponentInitializationException("can't create X.509 certificate factory", (Exception)e);
        }
    }

    @Override
    protected void doDestroy() {
        this.factory = null;
        super.doDestroy();
    }
}

