/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom.saml;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.dom.saml.SAMLMetadataSupport;
import net.shibboleth.metadata.pipeline.BaseIteratingStage;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NullableElements;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.xml.AttributeSupport;
import net.shibboleth.utilities.java.support.xml.ElementSupport;
import net.shibboleth.utilities.java.support.xml.SerializeSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@ThreadSafe
public class ContactPersonFilterStage
extends BaseIteratingStage<Element> {
    public static final String TECHNICAL = "technical";
    public static final String SUPPORT = "support";
    public static final String ADMINISTRATIVE = "administrative";
    public static final String BILLING = "billing";
    public static final String OTHER = "other";
    private final Logger log = LoggerFactory.getLogger(ContactPersonFilterStage.class);
    private Set<String> allowedTypes = ImmutableSet.copyOf((Object[])new String[]{"technical", "support", "administrative", "billing", "other"});
    private Set<String> designatedTypes = ImmutableSet.copyOf(this.allowedTypes);
    private boolean whitelistingTypes = true;

    @Nonnull
    @NonnullElements
    @Unmodifiable
    public Collection<String> getDesignateTypes() {
        return this.designatedTypes;
    }

    public synchronized void setDesignatedTypes(@Nullable @NullableElements Collection<String> types) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        if (types == null || types.isEmpty()) {
            this.designatedTypes = Collections.emptySet();
            return;
        }
        HashSet<String> checkedTypes = new HashSet<String>();
        for (String type : types) {
            String checkedType = StringSupport.trimOrNull((String)type);
            if (checkedType == null) continue;
            if (this.allowedTypes.contains(checkedType)) {
                checkedTypes.add(checkedType);
                continue;
            }
            this.log.debug("Stage {}: {} is not an allowed contact person type and so has been ignored", (Object)this.getId(), (Object)checkedType);
        }
        this.designatedTypes = Collections.unmodifiableSet(checkedTypes);
    }

    public boolean isWhitelistingTypes() {
        return this.whitelistingTypes;
    }

    public synchronized void setWhitelistingTypes(boolean whitelisting) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.whitelistingTypes = whitelisting;
    }

    @Override
    protected boolean doExecute(@Nonnull Item<Element> item) throws StageProcessingException {
        Element descriptor = item.unwrap();
        if (SAMLMetadataSupport.isEntitiesDescriptor(descriptor)) {
            this.processEntitiesDescriptor(descriptor);
        } else if (SAMLMetadataSupport.isEntityDescriptor(descriptor)) {
            this.processEntityDescriptor(descriptor);
        }
        return true;
    }

    protected void processEntitiesDescriptor(@Nonnull Element entitiesDescriptor) {
        List children = ElementSupport.getChildElements((Node)entitiesDescriptor);
        for (Element child : children) {
            if (SAMLMetadataSupport.isEntitiesDescriptor(child)) {
                this.processEntitiesDescriptor(child);
                continue;
            }
            if (!SAMLMetadataSupport.isEntityDescriptor(child)) continue;
            this.processEntityDescriptor(child);
        }
    }

    protected void processEntityDescriptor(@Nonnull Element entityDescriptor) {
        String entityId = entityDescriptor.getAttributeNS(null, "entityID");
        List contactPersons = ElementSupport.getChildElementsByTagNameNS((Node)entityDescriptor, (String)"urn:oasis:names:tc:SAML:2.0:metadata", (String)"ContactPerson");
        if (!contactPersons.isEmpty()) {
            this.log.debug("{} pipeline stage filtering ContactPerson from EntityDescriptor {}", (Object)this.getId(), (Object)entityId);
            for (Element contactPerson : contactPersons) {
                if (this.isRetainedContactPersonType(contactPerson)) continue;
                entityDescriptor.removeChild(contactPerson);
            }
        }
    }

    protected boolean isRetainedContactPersonType(@Nonnull Element contactPerson) {
        Constraint.isNotNull((Object)contactPerson, (String)"Contact person element can not be null");
        String type = StringSupport.trimOrNull((String)AttributeSupport.getAttributeValue((Element)contactPerson, null, (String)"contactType"));
        if (type == null) {
            this.log.debug("The following ContactPerson does not contain the required contactType attribute, it will be removed:\n{}", (Object)SerializeSupport.prettyPrintXML((Node)contactPerson));
            return false;
        }
        if (!this.allowedTypes.contains(type)) {
            this.log.debug("The following ContactPerson contained an invalid contactType, it will be removed:\n{}", (Object)SerializeSupport.prettyPrintXML((Node)contactPerson));
            return false;
        }
        if (this.isWhitelistingTypes() && this.designatedTypes.contains(type)) {
            return true;
        }
        return !this.isWhitelistingTypes() && !this.designatedTypes.contains(type);
    }

    protected void doDestroy() {
        this.designatedTypes = null;
        super.doDestroy();
    }
}

