/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom.saml;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.namespace.QName;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.dom.saml.SAMLMetadataSupport;
import net.shibboleth.metadata.pipeline.BaseIteratingStage;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NullableElements;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.xml.ElementSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@ThreadSafe
public class EntityFilterStage
extends BaseIteratingStage<Element> {
    private final Logger log = LoggerFactory.getLogger(EntityFilterStage.class);
    private Collection<String> designatedEntities = Collections.emptyList();
    private boolean whitelistingEntities;
    private boolean removingEntitylessEntitiesDescriptor = true;

    @Nonnull
    @NonnullElements
    @Unmodifiable
    public Collection<String> getDesignatedEntities() {
        return this.designatedEntities;
    }

    public synchronized void setDesignatedEntities(@Nullable @NullableElements Collection<String> ids) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.designatedEntities = ids == null || ids.isEmpty() ? Collections.emptyList() : ImmutableList.copyOf((Iterable)Iterables.filter(ids, (Predicate)Predicates.notNull()));
    }

    public boolean isWhitelistingEntities() {
        return this.whitelistingEntities;
    }

    public synchronized void setWhitelistingEntities(boolean whitelisting) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.whitelistingEntities = whitelisting;
    }

    public boolean isRemovingEntitylessEntitiesDescriptor() {
        return this.removingEntitylessEntitiesDescriptor;
    }

    public synchronized void setRemovingEntitylessEntitiesDescriptor(boolean remove) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.removingEntitylessEntitiesDescriptor = remove;
    }

    protected void doDestroy() {
        this.designatedEntities = null;
        super.doDestroy();
    }

    @Override
    protected boolean doExecute(@Nonnull Item<Element> item) {
        Element descriptor = item.unwrap();
        return !(SAMLMetadataSupport.isEntitiesDescriptor(descriptor) ? this.processEntitiesDescriptor(descriptor) : SAMLMetadataSupport.isEntityDescriptor(descriptor) && this.processEntityDescriptor(descriptor));
    }

    protected boolean processEntitiesDescriptor(@Nonnull Element entitiesDescriptor) {
        Element descriptor;
        List childEntitiesDescriptors = ElementSupport.getChildElements((Node)entitiesDescriptor, (QName)SAMLMetadataSupport.ENTITIES_DESCRIPTOR_NAME);
        Iterator descriptorItr = childEntitiesDescriptors.iterator();
        while (descriptorItr.hasNext()) {
            descriptor = (Element)descriptorItr.next();
            if (!this.processEntitiesDescriptor(descriptor)) continue;
            entitiesDescriptor.removeChild(descriptor);
            descriptorItr.remove();
        }
        List childEntityDescriptors = ElementSupport.getChildElements((Node)entitiesDescriptor, (QName)SAMLMetadataSupport.ENTITY_DESCRIPTOR_NAME);
        descriptorItr = childEntityDescriptors.iterator();
        while (descriptorItr.hasNext()) {
            descriptor = (Element)descriptorItr.next();
            if (!this.processEntityDescriptor(descriptor)) continue;
            entitiesDescriptor.removeChild(descriptor);
            descriptorItr.remove();
        }
        return this.removingEntitylessEntitiesDescriptor && childEntitiesDescriptors.isEmpty() && childEntityDescriptors.isEmpty();
    }

    protected boolean processEntityDescriptor(@Nonnull Element entityDescriptor) {
        String entityId = entityDescriptor.getAttributeNS(null, "entityID");
        if (this.designatedEntities.isEmpty()) {
            return false;
        }
        if (this.isWhitelistingEntities() && !this.designatedEntities.contains(entityId)) {
            this.log.debug("{} pipeline stage removing entity {} because it wasn't on the whitelist", (Object)this.getId(), (Object)entityId);
            return true;
        }
        if (!this.isWhitelistingEntities() && this.designatedEntities.contains(entityId)) {
            this.log.debug("{} pipeline stage removing entity {} because it was on the blacklist", (Object)this.getId(), (Object)entityId);
            return true;
        }
        return false;
    }
}

