/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom.saml;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.namespace.QName;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.dom.saml.SAMLMetadataSupport;
import net.shibboleth.metadata.pipeline.BaseIteratingStage;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NullableElements;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.xml.DOMTypeSupport;
import net.shibboleth.utilities.java.support.xml.ElementSupport;
import net.shibboleth.utilities.java.support.xml.QNameSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@ThreadSafe
public class EntityRoleFilterStage
extends BaseIteratingStage<Element> {
    public static final QName ROLE_DESCRIPTOR_NAME = new QName("urn:oasis:names:tc:SAML:2.0:metadata", "RoleDescriptor");
    public static final QName IDP_SSO_DESCRIPTOR_NAME = new QName("urn:oasis:names:tc:SAML:2.0:metadata", "IDPSSODescriptor");
    public static final QName SP_SSO_DESCRIPTOR_NAME = new QName("urn:oasis:names:tc:SAML:2.0:metadata", "SPSSODescriptor");
    public static final QName AUTHN_AUTHORITY_DESCRIPTOR_NAME = new QName("urn:oasis:names:tc:SAML:2.0:metadata", "AuthnAuthorityDescriptor");
    public static final QName ATTRIBUTE_AUTHORITY_DESCRIPTOR_NAME = new QName("urn:oasis:names:tc:SAML:2.0:metadata", "AttributeAuthorityDescriptor");
    public static final QName PDP_DESCRIPTOR_NAME = new QName("urn:oasis:names:tc:SAML:2.0:metadata", "PDPDescriptor");
    private final Logger log = LoggerFactory.getLogger(EntityRoleFilterStage.class);
    private final Set<QName> namedRoles = ImmutableSet.of((Object)IDP_SSO_DESCRIPTOR_NAME, (Object)SP_SSO_DESCRIPTOR_NAME, (Object)AUTHN_AUTHORITY_DESCRIPTOR_NAME, (Object)ATTRIBUTE_AUTHORITY_DESCRIPTOR_NAME, (Object)PDP_DESCRIPTOR_NAME);
    private Collection<QName> designatedRoles = Collections.emptyList();
    private boolean whitelistingRoles;
    private boolean removingRolelessEntities = true;
    private boolean removingEntitylessEntitiesDescriptor = true;

    @Nonnull
    @NonnullElements
    @Unmodifiable
    public Collection<QName> getDesignatedRoles() {
        return this.designatedRoles;
    }

    public synchronized void setDesignatedRoles(@Nullable @NullableElements Collection<QName> roles) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.designatedRoles = roles == null || roles.isEmpty() ? Collections.emptyList() : ImmutableList.copyOf((Iterable)Iterables.filter(roles, (Predicate)Predicates.notNull()));
    }

    public boolean isWhitelistingRoles() {
        return this.whitelistingRoles;
    }

    public synchronized void setWhitelistingRoles(boolean whitelisting) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.whitelistingRoles = whitelisting;
    }

    public boolean isRemovingRolelessEntities() {
        return this.removingRolelessEntities;
    }

    public synchronized void setRemoveRolelessEntities(boolean remove) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.removingRolelessEntities = remove;
    }

    public boolean isRemovingEntitylessEntitiesDescriptor() {
        return this.removingEntitylessEntitiesDescriptor;
    }

    public synchronized void setRemovingEntitylessEntitiesDescriptor(boolean remove) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.removingEntitylessEntitiesDescriptor = remove;
    }

    protected void doDestroy() {
        this.designatedRoles = null;
        super.doDestroy();
    }

    @Override
    protected boolean doExecute(@Nonnull Item<Element> item) {
        Element descriptor = item.unwrap();
        return !(SAMLMetadataSupport.isEntitiesDescriptor(descriptor) ? this.processEntitiesDescriptor(descriptor) : SAMLMetadataSupport.isEntityDescriptor(descriptor) && this.processEntityDescriptor(descriptor));
    }

    protected boolean processEntitiesDescriptor(@Nonnull Element entitiesDescriptor) {
        Element descriptor;
        List childEntitiesDescriptors = ElementSupport.getChildElements((Node)entitiesDescriptor, (QName)SAMLMetadataSupport.ENTITIES_DESCRIPTOR_NAME);
        Iterator descriptorItr = childEntitiesDescriptors.iterator();
        while (descriptorItr.hasNext()) {
            descriptor = (Element)descriptorItr.next();
            if (!this.processEntitiesDescriptor(descriptor)) continue;
            entitiesDescriptor.removeChild(descriptor);
            descriptorItr.remove();
        }
        List childEntityDescriptors = ElementSupport.getChildElements((Node)entitiesDescriptor, (QName)SAMLMetadataSupport.ENTITY_DESCRIPTOR_NAME);
        descriptorItr = childEntityDescriptors.iterator();
        while (descriptorItr.hasNext()) {
            descriptor = (Element)descriptorItr.next();
            if (!this.processEntityDescriptor(descriptor)) continue;
            entitiesDescriptor.removeChild(descriptor);
            descriptorItr.remove();
        }
        return this.removingEntitylessEntitiesDescriptor && childEntitiesDescriptors.isEmpty() && childEntityDescriptors.isEmpty();
    }

    protected boolean processEntityDescriptor(@Nonnull Element entityDescriptor) {
        if (this.designatedRoles.isEmpty()) {
            return false;
        }
        String entityId = entityDescriptor.getAttributeNS(null, "entityID");
        this.log.debug("{} pipeline stage filtering roles from EntityDescriptor {}", (Object)this.getId(), (Object)entityId);
        List<Element> roles = this.getFilteredRoles(entityId, entityDescriptor);
        return this.removingRolelessEntities && roles.isEmpty();
    }

    protected List<Element> getFilteredRoles(@Nonnull String entityId, @Nonnull Element entityDescriptor) {
        List childElements = ElementSupport.getChildElements((Node)entityDescriptor);
        Iterator childItr = childElements.iterator();
        while (childItr.hasNext()) {
            Element child = (Element)childItr.next();
            QName childQName = QNameSupport.getNodeQName((Node)child);
            QName roleIdentifier = null;
            if (Objects.equals(childQName, ROLE_DESCRIPTOR_NAME)) {
                roleIdentifier = DOMTypeSupport.getXSIType((Element)child);
            } else if (this.namedRoles.contains(childQName)) {
                roleIdentifier = childQName;
            } else {
                childItr.remove();
                continue;
            }
            boolean isDesignatedRole = this.designatedRoles.contains(roleIdentifier);
            if (roleIdentifier == null) continue;
            if (this.isWhitelistingRoles() && !isDesignatedRole || !this.isWhitelistingRoles() && isDesignatedRole) {
                this.log.debug("{} pipeline stage removing role {} from EntityDescriptor {}", new Object[]{this.getId(), roleIdentifier, entityId});
                entityDescriptor.removeChild(child);
                childItr.remove();
                continue;
            }
            this.log.debug("{} pipeline did not remove role {} from EntityDescriptor {}", new Object[]{this.getId(), roleIdentifier, entityId});
        }
        return childElements;
    }
}

