/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom.saml;

import javax.annotation.Nonnull;
import javax.xml.namespace.QName;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.dom.saml.SAMLMetadataSupport;
import net.shibboleth.metadata.pipeline.BaseIteratingStage;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.security.IdentifierGenerationStrategy;
import net.shibboleth.utilities.java.support.security.Type4UUIDIdentifierGenerationStrategy;
import net.shibboleth.utilities.java.support.xml.AttributeSupport;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GenerateIdStage
extends BaseIteratingStage<Element> {
    public static final QName ID_ATTRIB = new QName("ID");
    private final IdentifierGenerationStrategy idGenerator;

    public GenerateIdStage() {
        this.idGenerator = new Type4UUIDIdentifierGenerationStrategy();
    }

    public GenerateIdStage(@Nonnull IdentifierGenerationStrategy generator) {
        this.idGenerator = (IdentifierGenerationStrategy)Constraint.isNotNull((Object)generator, (String)"ID generation strategy can not be null");
    }

    @Override
    protected boolean doExecute(@Nonnull Item<Element> item) throws StageProcessingException {
        Element element = item.unwrap();
        if (!SAMLMetadataSupport.isEntityOrEntitiesDescriptor(element)) {
            return true;
        }
        Attr idAttribute = AttributeSupport.getAttribute((Element)element, (QName)ID_ATTRIB);
        if (idAttribute == null) {
            idAttribute = AttributeSupport.constructAttribute((Document)element.getOwnerDocument(), (QName)ID_ATTRIB);
            element.setAttributeNode(idAttribute);
        }
        idAttribute.setValue(this.idGenerator.generateIdentifier());
        return true;
    }
}

