/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom.saml;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.namespace.QName;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.dom.saml.SAMLMetadataSupport;
import net.shibboleth.metadata.pipeline.BaseIteratingStage;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.xml.AttributeSupport;
import net.shibboleth.utilities.java.support.xml.ElementSupport;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@ThreadSafe
public class PullUpCacheDurationStage
extends BaseIteratingStage<Element> {
    private long minCacheDuration;
    private long maxCacheDuration = Long.MAX_VALUE;

    public long getMinimumCacheDuration() {
        return this.minCacheDuration;
    }

    public synchronized void setMinimumCacheDuration(long duration) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.minCacheDuration = duration < 0L ? 0L : duration;
    }

    public long getMaximumCacheDuration() {
        return this.maxCacheDuration;
    }

    public synchronized void setMaximumCacheDuration(long duration) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        Constraint.isGreaterThan((long)0L, (long)duration, (String)"Maximum cache duration must be greater than 0");
        this.maxCacheDuration = duration;
    }

    @Override
    protected boolean doExecute(@Nonnull Item<Element> item) throws StageProcessingException {
        Element descriptor = item.unwrap();
        Long cacheDuration = this.getShortestCacheDuration(descriptor);
        this.setCacheDuration(descriptor, cacheDuration);
        return true;
    }

    protected Long getShortestCacheDuration(@Nonnull Element descriptor) {
        Long shortestCacheDuration = null;
        if (!SAMLMetadataSupport.isEntityOrEntitiesDescriptor(descriptor)) {
            return shortestCacheDuration;
        }
        Long cacheDuration = null;
        List entitiesDescriptors = ElementSupport.getChildElements((Node)descriptor, (QName)SAMLMetadataSupport.ENTITIES_DESCRIPTOR_NAME);
        for (Element entitiesDescriptor : entitiesDescriptors) {
            cacheDuration = this.getShortestCacheDuration(entitiesDescriptor);
            if (cacheDuration == null || shortestCacheDuration != null && cacheDuration >= shortestCacheDuration) continue;
            shortestCacheDuration = cacheDuration;
        }
        List entityDescriptors = ElementSupport.getChildElements((Node)descriptor, (QName)SAMLMetadataSupport.ENTITY_DESCRIPTOR_NAME);
        for (Element entityDescriptor : entityDescriptors) {
            cacheDuration = this.getShortestCacheDuration(entityDescriptor);
            if (cacheDuration == null || shortestCacheDuration != null && cacheDuration >= shortestCacheDuration) continue;
            shortestCacheDuration = cacheDuration;
        }
        Attr cacheDurationAttr = AttributeSupport.getAttribute((Element)descriptor, (QName)SAMLMetadataSupport.CACHE_DURATION_ATTRIB_NAME);
        if (cacheDurationAttr != null) {
            cacheDuration = AttributeSupport.getDurationAttributeValueAsLong((Attr)cacheDurationAttr);
            if (cacheDuration != null && (shortestCacheDuration == null || cacheDuration < shortestCacheDuration)) {
                shortestCacheDuration = cacheDuration;
            }
            descriptor.removeAttributeNode(cacheDurationAttr);
        }
        return shortestCacheDuration;
    }

    protected void setCacheDuration(@Nonnull Element descriptor, @Nullable Long cacheDuration) {
        if (cacheDuration == null || cacheDuration <= 0L) {
            return;
        }
        if (cacheDuration < this.minCacheDuration) {
            AttributeSupport.appendDurationAttribute((Element)descriptor, (QName)SAMLMetadataSupport.CACHE_DURATION_ATTRIB_NAME, (long)this.minCacheDuration);
        } else if (cacheDuration > this.maxCacheDuration) {
            AttributeSupport.appendDurationAttribute((Element)descriptor, (QName)SAMLMetadataSupport.CACHE_DURATION_ATTRIB_NAME, (long)this.maxCacheDuration);
        } else {
            AttributeSupport.appendDurationAttribute((Element)descriptor, (QName)SAMLMetadataSupport.CACHE_DURATION_ATTRIB_NAME, (long)cacheDuration);
        }
    }
}

