/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom.saml;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.dom.saml.ContactPersonFilterStage;
import net.shibboleth.metadata.dom.saml.SAMLMetadataSupport;
import net.shibboleth.metadata.pipeline.BaseIteratingStage;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import net.shibboleth.utilities.java.support.xml.ElementSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@ThreadSafe
public class RemoveOrganizationStage
extends BaseIteratingStage<Element> {
    private final Logger log = LoggerFactory.getLogger(ContactPersonFilterStage.class);

    @Override
    protected boolean doExecute(@Nonnull Item<Element> item) throws StageProcessingException {
        Element descriptor = item.unwrap();
        if (SAMLMetadataSupport.isEntitiesDescriptor(descriptor)) {
            this.processEntitiesDescriptor(descriptor);
        } else if (SAMLMetadataSupport.isEntityDescriptor(descriptor)) {
            this.processEntityDescriptor(descriptor);
        }
        return true;
    }

    protected void processEntitiesDescriptor(@Nonnull Element entitiesDescriptor) {
        List children = ElementSupport.getChildElements((Node)entitiesDescriptor);
        for (Element child : children) {
            if (SAMLMetadataSupport.isEntitiesDescriptor(child)) {
                this.processEntitiesDescriptor(child);
                continue;
            }
            if (!SAMLMetadataSupport.isEntityDescriptor(child)) continue;
            this.processEntityDescriptor(child);
        }
    }

    protected void processEntityDescriptor(@Nonnull Element entityDescriptor) {
        String entityId = entityDescriptor.getAttributeNS(null, "entityID");
        List organizations = ElementSupport.getChildElementsByTagNameNS((Node)entityDescriptor, (String)"urn:oasis:names:tc:SAML:2.0:metadata", (String)"Organization");
        if (!organizations.isEmpty()) {
            this.log.debug("{} pipeline stage filtering Organization from EntityDescriptor {}", (Object)this.getId(), (Object)entityId);
            for (Element organization : organizations) {
                entityDescriptor.removeChild(organization);
            }
        }
    }
}

