/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom.saml;

import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.namespace.QName;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.dom.saml.SAMLMetadataSupport;
import net.shibboleth.metadata.pipeline.BaseIteratingStage;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import net.shibboleth.utilities.java.support.annotation.Duration;
import net.shibboleth.utilities.java.support.annotation.constraint.Positive;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.xml.AttributeSupport;
import org.w3c.dom.Element;

@ThreadSafe
public class SetCacheDurationStage
extends BaseIteratingStage<Element> {
    @Duration
    private long cacheDuration;

    public long getCacheDuration() {
        return this.cacheDuration;
    }

    public synchronized void setCacheDuration(@Duration @Positive long duration) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.cacheDuration = Constraint.isGreaterThan((long)0L, (long)duration, (String)"cache duration must be greater than 0");
    }

    @Override
    protected boolean doExecute(@Nonnull Item<Element> item) throws StageProcessingException {
        Element descriptor = item.unwrap();
        if (SAMLMetadataSupport.isEntityOrEntitiesDescriptor(descriptor)) {
            AttributeSupport.removeAttribute((Element)descriptor, (QName)SAMLMetadataSupport.CACHE_DURATION_ATTRIB_NAME);
            AttributeSupport.appendDurationAttribute((Element)descriptor, (QName)SAMLMetadataSupport.CACHE_DURATION_ATTRIB_NAME, (long)this.cacheDuration);
        }
        return true;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.cacheDuration <= 0L) {
            throw new ComponentInitializationException("cache duration must be greater than 0");
        }
    }
}

