/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom.saml;

import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.namespace.QName;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.dom.saml.SAMLMetadataSupport;
import net.shibboleth.metadata.pipeline.BaseIteratingStage;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import net.shibboleth.utilities.java.support.annotation.Duration;
import net.shibboleth.utilities.java.support.annotation.constraint.Positive;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.xml.AttributeSupport;
import org.w3c.dom.Element;

@ThreadSafe
public class SetValidUntilStage
extends BaseIteratingStage<Element> {
    @Duration
    private long validityDuration;

    public long getValidityDuration() {
        return this.validityDuration;
    }

    public synchronized void setValidityDuration(@Duration @Positive long duration) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.validityDuration = Constraint.isGreaterThan((long)0L, (long)duration, (String)"validity duration must be greater than 0");
    }

    @Override
    protected boolean doExecute(@Nonnull Item<Element> item) throws StageProcessingException {
        Element descriptor = item.unwrap();
        if (SAMLMetadataSupport.isEntityOrEntitiesDescriptor(descriptor)) {
            AttributeSupport.removeAttribute((Element)descriptor, (QName)SAMLMetadataSupport.VALID_UNTIL_ATTRIB_NAME);
            AttributeSupport.appendDateTimeAttribute((Element)descriptor, (QName)SAMLMetadataSupport.VALID_UNTIL_ATTRIB_NAME, (long)(System.currentTimeMillis() + this.validityDuration));
        }
        return true;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.validityDuration <= 0L) {
            throw new ComponentInitializationException("validity duration must be greater than 0");
        }
    }
}

