/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom.saml;

import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.namespace.QName;
import net.shibboleth.metadata.ErrorStatus;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.dom.saml.SAMLMetadataSupport;
import net.shibboleth.metadata.pipeline.BaseIteratingStage;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.xml.AttributeSupport;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

@ThreadSafe
public class ValidateValidUntilStage
extends BaseIteratingStage<Element> {
    private boolean requireValidUntil = true;
    private long maxValidityInterval = 604800000L;

    public boolean isRequireValidUntil() {
        return this.requireValidUntil;
    }

    public synchronized void setRequireValidUntil(boolean isRequired) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.requireValidUntil = isRequired;
    }

    public long getMaxValidityInterval() {
        return this.maxValidityInterval;
    }

    public synchronized void setMaxValidityInterval(long interval) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.maxValidityInterval = interval;
    }

    @Override
    protected boolean doExecute(@Nonnull Item<Element> item) throws StageProcessingException {
        Element element = item.unwrap();
        if (!SAMLMetadataSupport.isEntitiesDescriptor(element)) {
            return true;
        }
        Long validUntil = AttributeSupport.getDateTimeAttributeAsLong((Attr)AttributeSupport.getAttribute((Element)element, (QName)SAMLMetadataSupport.VALID_UNTIL_ATTRIB_NAME));
        if (validUntil == null) {
            if (this.requireValidUntil) {
                item.getItemMetadata().put((Object)new ErrorStatus(this.getId(), "Item does not include a validUntil attribute"));
            }
        } else {
            long lowerBound = System.currentTimeMillis();
            if (validUntil < lowerBound) {
                item.getItemMetadata().put((Object)new ErrorStatus(this.getId(), "Item has a validUntil prior to the current time"));
            }
            if (this.maxValidityInterval > 0L) {
                long upperBound = lowerBound + this.maxValidityInterval;
                if (validUntil > upperBound) {
                    item.getItemMetadata().put((Object)new ErrorStatus(this.getId(), "Item has validUntil larger than the maximum validity interval"));
                }
            }
        }
        return true;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.maxValidityInterval < 0L) {
            throw new ComponentInitializationException("Max validity interval must be greater than or equal to 0");
        }
    }
}

