/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom.saml.mdattr;

import com.google.common.base.Predicate;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.dom.saml.SAMLMetadataSupport;
import net.shibboleth.metadata.dom.saml.SAMLSupport;
import net.shibboleth.metadata.dom.saml.mdattr.MDAttrSupport;
import net.shibboleth.metadata.dom.saml.mdrpi.RegistrationAuthority;
import net.shibboleth.metadata.pipeline.BaseStage;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.xml.ElementSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EntityAttributeFilteringStage
extends BaseStage<Element> {
    private final Logger log = LoggerFactory.getLogger(EntityAttributeFilteringStage.class);
    private List<Predicate<EntityAttributeContext>> rules = Collections.emptyList();
    private boolean whitelisting = true;

    public void setRules(@Nonnull List<Predicate<EntityAttributeContext>> newRules) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.rules = (List)Constraint.isNotNull(newRules, (String)"rules property may not be null");
    }

    @Nonnull
    public List<Predicate<EntityAttributeContext>> getRules() {
        return Collections.unmodifiableList(this.rules);
    }

    public void setWhitelisting(boolean newValue) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.whitelisting = newValue;
    }

    public boolean isWhitelisting() {
        return this.whitelisting;
    }

    private boolean applyRules(EntityAttributeContext ctx) {
        for (Predicate<EntityAttributeContext> rule : this.rules) {
            if (!rule.apply((Object)ctx)) continue;
            return true;
        }
        return false;
    }

    private String extractRegistrationAuthority(@Nonnull Item<Element> item) {
        List regAuthList = item.getItemMetadata().get(RegistrationAuthority.class);
        if (regAuthList.isEmpty()) {
            return null;
        }
        return ((RegistrationAuthority)regAuthList.get(0)).getRegistrationAuthority();
    }

    private void filterAttribute(@Nonnull Element attribute, @Nullable String registrationAuthority) {
        String attributeName = attribute.getAttribute("Name");
        String attributeNameFormat = SAMLSupport.extractAttributeNameFormat(attribute);
        List attributeValues = ElementSupport.getChildElements((Node)attribute, (QName)SAMLSupport.ATTRIBUTE_VALUE_NAME);
        for (Element value : attributeValues) {
            String attributeValue = value.getTextContent();
            ContextImpl ctx = new ContextImpl(attributeValue, attributeName, attributeNameFormat, registrationAuthority);
            boolean matched = this.applyRules(ctx);
            if (!(matched ^ this.whitelisting)) continue;
            this.log.debug("removing {}", (Object)ctx);
            attribute.removeChild(value);
        }
    }

    private void filterEntityAttributes(@Nonnull Element entityAttributes, @Nullable String registrationAuthority) {
        List attributes = ElementSupport.getChildElements((Node)entityAttributes, (QName)SAMLSupport.ATTRIBUTE_NAME);
        for (Element attribute : attributes) {
            this.filterAttribute(attribute, registrationAuthority);
            if (ElementSupport.getFirstChildElement((Node)attribute) != null) continue;
            this.log.debug("removing empty Attribute");
            entityAttributes.removeChild(attribute);
        }
    }

    @Override
    protected void doExecute(Collection<Item<Element>> itemCollection) throws StageProcessingException {
        for (Item<Element> item : itemCollection) {
            Element entity = item.unwrap();
            String registrationAuthority = this.extractRegistrationAuthority(item);
            for (Element entityAttributes : SAMLMetadataSupport.getDescriptorExtensionList(entity, MDAttrSupport.ENTITY_ATTRIBUTES_NAME)) {
                this.filterEntityAttributes(entityAttributes, registrationAuthority);
                if (ElementSupport.getFirstChildElement((Node)entityAttributes) != null) continue;
                this.log.debug("removing empty EntityAttributes");
                Node extensions = entityAttributes.getParentNode();
                extensions.removeChild(entityAttributes);
            }
        }
    }

    protected void doDestroy() {
        this.rules = null;
        super.doDestroy();
    }

    static class ContextImpl
    implements EntityAttributeContext {
        @Nonnull
        private final String value;
        @Nonnull
        private final String name;
        @Nonnull
        private final String nameFormat;
        @Nullable
        private final String registrationAuthority;

        public ContextImpl(@Nonnull String attributeValue, @Nonnull String attributeName, @Nonnull String attributeNameFormat, @Nullable String registrar) {
            this.value = (String)Constraint.isNotNull((Object)attributeValue, (String)"value may not be null");
            this.name = (String)Constraint.isNotNull((Object)attributeName, (String)"name may not be null");
            this.nameFormat = (String)Constraint.isNotNull((Object)attributeNameFormat, (String)"name format may not be null");
            this.registrationAuthority = registrar;
        }

        public ContextImpl(@Nonnull String attributeValue, @Nonnull String attributeName, @Nonnull String attributeNameFormat) {
            this(attributeValue, attributeName, attributeNameFormat, null);
        }

        @Override
        public String getRegistrationAuthority() {
            return this.registrationAuthority;
        }

        @Override
        public String getNameFormat() {
            return this.nameFormat;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            b.append("{v=").append(this.getValue());
            b.append(", n=").append(this.getName());
            b.append(", f=").append(this.getNameFormat());
            b.append(", r=");
            if (this.getRegistrationAuthority() == null) {
                b.append("(none)");
            } else {
                b.append(this.getRegistrationAuthority());
            }
            b.append('}');
            return b.toString();
        }
    }

    public static interface EntityAttributeContext {
        @Nullable
        public String getRegistrationAuthority();

        @Nonnull
        public String getNameFormat();

        @Nonnull
        public String getName();

        @Nonnull
        public String getValue();
    }
}

