/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom.saml.mdattr;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.metadata.dom.saml.mdattr.AbstractEntityAttributeMatcher;
import net.shibboleth.utilities.java.support.logic.Constraint;

@ThreadSafe
public class MultiPredicateMatcher
extends AbstractEntityAttributeMatcher {
    @Nonnull
    private Predicate<CharSequence> valuePredicate = Predicates.alwaysTrue();
    @Nonnull
    private Predicate<CharSequence> namePredicate = Predicates.alwaysTrue();
    @Nonnull
    private Predicate<CharSequence> nameFormatPredicate = Predicates.alwaysTrue();
    @Nonnull
    private Predicate<CharSequence> registrationAuthorityPredicate = Predicates.alwaysTrue();

    @Nonnull
    public Predicate<CharSequence> getValuePredicate() {
        return this.valuePredicate;
    }

    public void setValuePredicate(@Nonnull Predicate<CharSequence> predicate) {
        this.valuePredicate = (Predicate)Constraint.isNotNull(predicate, (String)"value predicate may not be null");
    }

    @Nonnull
    public Predicate<CharSequence> getNamePredicate() {
        return this.namePredicate;
    }

    public void setNamePredicate(@Nonnull Predicate<CharSequence> predicate) {
        this.namePredicate = (Predicate)Constraint.isNotNull(predicate, (String)"name predicate may not be null");
    }

    @Nonnull
    public Predicate<CharSequence> getNameFormatPredicate() {
        return this.nameFormatPredicate;
    }

    public void setNameFormatPredicate(@Nonnull Predicate<CharSequence> predicate) {
        this.nameFormatPredicate = (Predicate)Constraint.isNotNull(predicate, (String)"name format predicate may not be null");
    }

    @Nonnull
    public Predicate<CharSequence> getRegistrationAuthorityPredicate() {
        return this.valuePredicate;
    }

    public void setRegistrationAuthorityPredicate(@Nonnull Predicate<CharSequence> predicate) {
        this.registrationAuthorityPredicate = (Predicate)Constraint.isNotNull(predicate, (String)"registration authority predicate may not be null");
    }

    @Override
    protected boolean matchAttributeValue(@Nonnull String inputValue) {
        return this.valuePredicate.apply((Object)inputValue);
    }

    @Override
    protected boolean matchAttributeName(@Nonnull String inputName) {
        return this.namePredicate.apply((Object)inputName);
    }

    @Override
    protected boolean matchAttributeNameFormat(@Nonnull String inputNameFormat) {
        return this.nameFormatPredicate.apply((Object)inputNameFormat);
    }

    @Override
    protected boolean matchRegistrationAuthority(@Nullable String inputRegistrationAuthority) {
        return this.registrationAuthorityPredicate.apply((Object)inputRegistrationAuthority);
    }
}

