/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom.saml.mdrpi;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.metadata.FirstItemIdItemIdentificationStrategy;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.dom.saml.mdrpi.RegistrationAuthority;

@ThreadSafe
public class RegistrationAuthorityItemIdentificationStrategy
extends FirstItemIdItemIdentificationStrategy {
    @Nonnull
    private Set<String> ignoredRegistrationAuthorities = Collections.emptySet();
    @Nonnull
    private Map<String, String> registrationAuthorityDisplayNames = Collections.emptyMap();

    @Nonnull
    public Collection<String> getIgnoredRegistrationAuthorities() {
        return this.ignoredRegistrationAuthorities;
    }

    public void setIgnoredRegistrationAuthorities(@Nullable Collection<String> registrars) {
        this.ignoredRegistrationAuthorities = registrars == null || registrars.isEmpty() ? Collections.emptySet() : ImmutableSet.copyOf(registrars);
    }

    public Map<String, String> getRegistrationAuthorityDisplayNames() {
        return this.registrationAuthorityDisplayNames;
    }

    public void setRegistrationAuthorityDisplayNames(@Nullable Map<String, String> names) {
        this.registrationAuthorityDisplayNames = names == null || names.isEmpty() ? Collections.emptyMap() : ImmutableMap.copyOf(names);
    }

    @Override
    @Nullable
    protected String getExtraIdentifier(@Nonnull Item<?> item) {
        List regAuths = item.getItemMetadata().get(RegistrationAuthority.class);
        if (regAuths.isEmpty()) {
            return null;
        }
        String regAuth = ((RegistrationAuthority)regAuths.get(0)).getRegistrationAuthority();
        if (this.ignoredRegistrationAuthorities.contains(regAuth)) {
            return null;
        }
        String displayName = this.registrationAuthorityDisplayNames.get(regAuth);
        if (displayName != null) {
            return displayName;
        }
        return regAuth;
    }
}

