/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom.saml.mdrpi;

import com.google.common.base.Strings;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.metadata.ErrorStatus;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.ItemMetadata;
import net.shibboleth.metadata.dom.saml.SAMLMetadataSupport;
import net.shibboleth.metadata.dom.saml.mdrpi.MDRPIMetadataSupport;
import net.shibboleth.metadata.dom.saml.mdrpi.RegistrationAuthority;
import net.shibboleth.metadata.pipeline.BaseStage;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.collection.ClassToInstanceMultiMap;
import net.shibboleth.utilities.java.support.xml.AttributeSupport;
import org.w3c.dom.Element;

@ThreadSafe
public class RegistrationAuthorityPopulationStage
extends BaseStage<Element> {
    @Override
    protected void doExecute(@Nonnull @NonnullElements Collection<Item<Element>> items) throws StageProcessingException {
        for (Item<Element> item : items) {
            Element entity = item.unwrap();
            ClassToInstanceMultiMap<ItemMetadata> metadata = item.getItemMetadata();
            if (!SAMLMetadataSupport.isEntityDescriptor(entity)) {
                metadata.put((Object)new ErrorStatus(this.getId(), "item was not an EntityDescriptor"));
                continue;
            }
            Element regInfo = SAMLMetadataSupport.getDescriptorExtensions(entity, MDRPIMetadataSupport.MDRPI_REGISTRATION_INFO);
            if (regInfo == null) continue;
            String attr = AttributeSupport.getAttributeValue((Element)regInfo, null, (String)"registrationAuthority");
            if (attr == null) {
                String eid = Strings.nullToEmpty((String)AttributeSupport.getAttributeValue((Element)entity, null, (String)"entityID"));
                metadata.put((Object)new ErrorStatus(this.getId(), "RegistrationInfo for " + eid + " did not have a RegistrationAuthority attribute"));
                continue;
            }
            metadata.put((Object)new RegistrationAuthority(attr));
        }
    }
}

