/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.pipeline;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.metadata.FirstItemIdItemIdentificationStrategy;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.ItemIdentificationStrategy;
import net.shibboleth.metadata.ItemMetadata;
import net.shibboleth.metadata.pipeline.BaseStage;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NullableElements;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;

@ThreadSafe
public abstract class AbstractItemMetadataSelectionStage<T>
extends BaseStage<T> {
    private Collection<Class<? extends ItemMetadata>> selectionRequirements = Collections.emptyList();
    private ItemIdentificationStrategy identificationStrategy = new FirstItemIdItemIdentificationStrategy();

    @Nonnull
    @NonnullElements
    @Unmodifiable
    public Collection<Class<? extends ItemMetadata>> getSelectionRequirements() {
        return this.selectionRequirements;
    }

    public synchronized void setSelectionRequirements(@Nullable @NullableElements Collection<Class<? extends ItemMetadata>> requirements) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.selectionRequirements = requirements == null ? Collections.emptyList() : ImmutableList.copyOf((Iterable)Iterables.filter(requirements, (Predicate)Predicates.notNull()));
    }

    @Nonnull
    public ItemIdentificationStrategy getItemIdentificationStrategy() {
        return this.identificationStrategy;
    }

    public synchronized void setIdentificationStrategy(@Nonnull ItemIdentificationStrategy strategy) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.identificationStrategy = (ItemIdentificationStrategy)Constraint.isNotNull((Object)strategy, (String)"Item identification strategy can not be null");
    }

    @Override
    protected void doExecute(Collection<Item<T>> itemCollection) throws StageProcessingException {
        ArrayList<Item<T>> collectionCopy = new ArrayList<Item<T>>(itemCollection);
        for (Item<T> item : collectionCopy) {
            HashMap<Class<? extends ItemMetadata>, List<? extends ItemMetadata>> matchingMetadata = new HashMap<Class<? extends ItemMetadata>, List<? extends ItemMetadata>>();
            for (Class<? extends ItemMetadata> infoClass : this.selectionRequirements) {
                if (!item.getItemMetadata().containsKey(infoClass)) continue;
                matchingMetadata.put(infoClass, item.getItemMetadata().get(infoClass));
            }
            if (matchingMetadata.isEmpty()) continue;
            this.doExecute(itemCollection, item, matchingMetadata);
        }
    }

    protected void doDestroy() {
        this.selectionRequirements = null;
        this.identificationStrategy = null;
        super.doDestroy();
    }

    protected abstract void doExecute(@Nonnull @NonnullElements Collection<Item<T>> var1, @Nonnull Item<T> var2, @Nonnull @NonnullElements Map<Class<? extends ItemMetadata>, List<? extends ItemMetadata>> var3) throws StageProcessingException;
}

