/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.pipeline;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.pipeline.ComponentInfo;
import net.shibboleth.metadata.pipeline.Stage;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import net.shibboleth.metadata.util.ItemMetadataSupport;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;

@ThreadSafe
public abstract class BaseStage<T>
extends AbstractIdentifiableInitializableComponent
implements Stage<T> {
    @Nonnull
    private Predicate<Collection<Item<T>>> collectionPredicate = Predicates.alwaysTrue();

    public void setCollectionPredicate(@Nonnull Predicate<Collection<Item<T>>> pred) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.collectionPredicate = (Predicate)Constraint.isNotNull(pred, (String)"collectionPredicate may not be null");
    }

    @Nonnull
    public Predicate<Collection<Item<T>>> getCollectionPredicate() {
        return this.collectionPredicate;
    }

    @Override
    public void execute(@Nonnull @NonnullElements Collection<Item<T>> itemCollection) throws StageProcessingException {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        ComponentInfo compInfo = new ComponentInfo(this);
        if (this.collectionPredicate.apply(itemCollection)) {
            this.doExecute(itemCollection);
        }
        ItemMetadataSupport.addToAll(itemCollection, Collections.singleton(compInfo));
        compInfo.setCompleteInstant();
    }

    protected abstract void doExecute(@Nonnull @NonnullElements Collection<Item<T>> var1) throws StageProcessingException;
}

