/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.pipeline;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.metadata.ItemMetadata;
import net.shibboleth.utilities.java.support.component.IdentifiedComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.chrono.ISOChronology;

public class ComponentInfo
implements ItemMetadata {
    private static final long serialVersionUID = -2181091708008092869L;
    private String componentId;
    private Class<?> componentType;
    private DateTime startInstant;
    private DateTime completeInstant;

    public ComponentInfo() {
    }

    public ComponentInfo(@Nonnull IdentifiedComponent component) {
        Constraint.isNotNull((Object)component, (String)"Component can not be null");
        this.componentId = component.getId();
        this.componentType = component.getClass();
        this.startInstant = new DateTime((Chronology)ISOChronology.getInstanceUTC());
    }

    @Nullable
    public String getComponentId() {
        return this.componentId;
    }

    public void setComponentId(@Nullable String id) {
        this.componentId = StringSupport.trimOrNull((String)id);
    }

    @Nullable
    public Class<?> getComponentType() {
        return this.componentType;
    }

    public void setComponentType(@Nullable Class<?> type) {
        this.componentType = type;
    }

    @Nullable
    public DateTime getStartInstant() {
        return this.startInstant;
    }

    public void setStartInstant(@Nullable DateTime instant) {
        this.startInstant = instant;
    }

    @Nullable
    public DateTime getCompleteInstant() {
        return this.completeInstant;
    }

    public void setCompleteInstant() {
        this.completeInstant = new DateTime((Chronology)ISOChronology.getInstanceUTC());
    }

    public void setCompleteInstant(@Nullable DateTime instant) {
        this.completeInstant = instant;
    }
}

