/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.pipeline;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.annotation.Nonnull;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.ItemId;
import net.shibboleth.metadata.pipeline.MultiOutputSerializationStage;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.component.AbstractInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilesInDirectoryMultiOutputStrategy<T>
extends AbstractInitializableComponent
implements MultiOutputSerializationStage.OutputStrategy<T> {
    private final Logger log = LoggerFactory.getLogger(FilesInDirectoryMultiOutputStrategy.class);
    @Nonnull
    private String namePrefix = "";
    @Nonnull
    private Function<String, String> nameTransformer = Functions.identity();
    @Nonnull
    private String nameSuffix = "";
    @NonnullAfterInit
    private File directory;

    @Nonnull
    public String getNamePrefix() {
        return this.namePrefix;
    }

    public void setNamePrefix(@Nonnull String prefix) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.namePrefix = (String)Constraint.isNotNull((Object)prefix, (String)"name prefix may not be null");
    }

    @Nonnull
    public Function<String, String> getNameTransformer() {
        return this.nameTransformer;
    }

    public void setNameTransformer(@Nonnull Function<String, String> transformer) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.nameTransformer = (Function)Constraint.isNotNull(transformer, (String)"name transformer may not be null");
    }

    @Nonnull
    public String getNameSuffix() {
        return this.nameSuffix;
    }

    public void setNameSuffix(@Nonnull String suffix) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.nameSuffix = (String)Constraint.isNotNull((Object)suffix, (String)"name suffix may not be null");
    }

    @Nonnull
    public File getDirectory() {
        return this.directory;
    }

    public void setDirectory(@Nonnull File dir) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.directory = (File)Constraint.isNotNull((Object)dir, (String)"directory may not be null");
    }

    @Override
    public MultiOutputSerializationStage.Destination getDestination(Item<T> item) throws StageProcessingException {
        List ids = item.getItemMetadata().get(ItemId.class);
        if (ids.isEmpty()) {
            throw new StageProcessingException("item has no ItemId to base a file name on");
        }
        ItemId id = (ItemId)ids.get(0);
        String name = this.namePrefix + (String)this.nameTransformer.apply((Object)id.getId()) + this.nameSuffix;
        this.log.debug("id mapped {} -> {}", (Object)id.getId(), (Object)name);
        File outputFile = new File(this.directory, name);
        return new FileDestination(outputFile);
    }

    protected void doDestroy() {
        this.namePrefix = null;
        this.nameTransformer = null;
        this.nameSuffix = null;
        this.directory = null;
        super.doDestroy();
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.directory == null) {
            throw new ComponentInitializationException("directory can not be null");
        }
        if (!this.directory.canWrite()) {
            throw new ComponentInitializationException("Can not write to parent directory of output files");
        }
    }

    private class FileDestination
    implements MultiOutputSerializationStage.Destination {
        private final File file;

        protected FileDestination(File f) {
            this.file = f;
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public OutputStream getOutputStream() throws IOException {
            return new FileOutputStream(this.file);
        }
    }
}

