/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.pipeline;

import java.util.Collection;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class FutureSupport {
    private static final Logger LOG = LoggerFactory.getLogger(FutureSupport.class);

    private FutureSupport() {
    }

    @Nonnull
    public static <T> Future<T> futureNow(T t) {
        return new FutureNow<T>(t);
    }

    @Nonnull
    public static <T> Collection<Item<T>> futureItems(@Nonnull Future<Collection<Item<T>>> future) throws StageProcessingException {
        assert (future != null);
        try {
            Collection<Item<T>> value = future.get();
            if (value == null) {
                throw new StageProcessingException("null returned from future value");
            }
            return value;
        }
        catch (ExecutionException e) {
            LOG.debug("Pipeline threw an unexpected exception", (Throwable)e);
            if (e.getCause() instanceof StageProcessingException) {
                throw (StageProcessingException)e.getCause();
            }
            throw new StageProcessingException("ExecutionException during processing", e);
        }
        catch (InterruptedException e) {
            LOG.debug("Execution service was interrupted", (Throwable)e);
            throw new StageProcessingException("Execution service was interrupted", e);
        }
    }

    private static class FutureNow<T>
    implements Future<T> {
        private final T value;

        FutureNow(T t) {
            this.value = t;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return true;
        }

        @Override
        public T get() throws InterruptedException, ExecutionException {
            return this.value;
        }

        @Override
        public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.value;
        }
    }
}

