/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.pipeline;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.ItemId;
import net.shibboleth.metadata.pipeline.BaseIteratingStage;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import net.shibboleth.utilities.java.support.collection.CollectionSupport;
import net.shibboleth.utilities.java.support.collection.LazyList;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import org.springframework.core.convert.converter.Converter;

@ThreadSafe
public class ItemIdTransformStage<T>
extends BaseIteratingStage<T> {
    private Collection<Converter<String, String>> idTransformers = new LazyList();

    public Collection<Converter<String, String>> getIdTransformers() {
        return this.idTransformers;
    }

    public synchronized void setIdTransformers(Collection<Converter<String, String>> transformers) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        CollectionSupport.addIf(this.idTransformers, transformers, (Predicate)Predicates.notNull());
    }

    @Override
    protected boolean doExecute(@Nonnull Item<T> item) throws StageProcessingException {
        List ids = item.getItemMetadata().get(ItemId.class);
        ArrayList<ItemId> transformedIds = new ArrayList<ItemId>();
        for (ItemId id : ids) {
            for (Converter<String, String> idTransform : this.idTransformers) {
                String transformedId = (String)idTransform.convert((Object)id.getId());
                transformedIds.add(new ItemId(transformedId));
            }
        }
        item.getItemMetadata().putAll(transformedIds);
        return true;
    }
}

