/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.pipeline;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.ItemMetadata;
import net.shibboleth.metadata.pipeline.BaseIteratingStage;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import net.shibboleth.utilities.java.support.collection.CollectionSupport;
import net.shibboleth.utilities.java.support.collection.LazyList;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;

@ThreadSafe
public class ItemMetadataAddingStage<T>
extends BaseIteratingStage<T> {
    private Collection<ItemMetadata> additionalItemMetadata = new LazyList();

    @Nonnull
    public Collection<ItemMetadata> getAdditionalItemMetadata() {
        return this.additionalItemMetadata;
    }

    public void setAdditionalItemMetadata(@Nonnull Collection<ItemMetadata> metadata) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        Constraint.isNotNull(metadata, (String)"additional metadata collection must not be null");
        this.additionalItemMetadata = new LazyList();
        CollectionSupport.addIf(this.additionalItemMetadata, metadata, (Predicate)Predicates.notNull());
    }

    @Override
    protected boolean doExecute(@Nonnull Item<T> item) throws StageProcessingException {
        item.getItemMetadata().putAll(this.additionalItemMetadata);
        return true;
    }
}

