/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.pipeline;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.ItemMetadata;
import net.shibboleth.metadata.pipeline.AbstractItemMetadataSelectionStage;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class ItemMetadataFilterStage<T>
extends AbstractItemMetadataSelectionStage<T> {
    private final Logger log = LoggerFactory.getLogger(ItemMetadataFilterStage.class);

    @Override
    protected void doExecute(@Nonnull @NonnullElements Collection<Item<T>> itemCollection, Item<T> matchingItem, Map<Class<? extends ItemMetadata>, List<? extends ItemMetadata>> matchingMetadata) throws StageProcessingException {
        String itemId = this.getItemIdentificationStrategy().getItemIdentifier(matchingItem);
        this.log.debug("Item {} was removed because it was marked with {}", (Object)itemId, matchingMetadata.keySet());
        itemCollection.remove(matchingItem);
    }
}

