/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.pipeline;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.ItemSerializer;
import net.shibboleth.metadata.pipeline.BaseStage;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;

@ThreadSafe
public class MultiOutputSerializationStage<T>
extends BaseStage<T> {
    private OutputStrategy<T> outputStrategy;
    private ItemSerializer<T> serializer;

    @Nullable
    public OutputStrategy<T> getOutputStrategy() {
        return this.outputStrategy;
    }

    public synchronized void setOutputStrategy(@Nonnull OutputStrategy<T> strategy) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.outputStrategy = (OutputStrategy)Constraint.isNotNull(strategy, (String)"Output strategy can not be null");
    }

    @Nullable
    public ItemSerializer<T> getSerializer() {
        return this.serializer;
    }

    public synchronized void setSerializer(@Nonnull ItemSerializer<T> itemSerializer) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.serializer = (ItemSerializer)Constraint.isNotNull(itemSerializer, (String)"Item serializer can not be null");
    }

    @Override
    protected void doExecute(@Nonnull @NonnullElements Collection<Item<T>> itemCollection) throws StageProcessingException {
        for (Item<T> item : itemCollection) {
            try {
                Destination destination = this.outputStrategy.getDestination(item);
                Throwable throwable = null;
                try {
                    OutputStream stream = destination.getOutputStream();
                    Throwable throwable2 = null;
                    try {
                        this.serializer.serialize(item, stream);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (stream == null) continue;
                        if (throwable2 != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable x2) {
                                throwable2.addSuppressed(x2);
                            }
                            continue;
                        }
                        stream.close();
                    }
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (destination == null) continue;
                    if (throwable != null) {
                        try {
                            destination.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    destination.close();
                }
            }
            catch (IOException e) {
                throw new StageProcessingException("Error writing to output location", e);
            }
        }
    }

    protected void doDestroy() {
        this.outputStrategy = null;
        this.serializer = null;
        super.doDestroy();
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.outputStrategy == null) {
            throw new ComponentInitializationException("Output strategy can not be null");
        }
        if (this.serializer == null) {
            throw new ComponentInitializationException("Item collection serializer can not be null");
        }
    }

    public static interface OutputStrategy<T> {
        @Nonnull
        public Destination getDestination(@Nonnull Item<T> var1) throws StageProcessingException;
    }

    public static interface Destination
    extends Closeable {
        @Nonnull
        public OutputStream getOutputStream() throws IOException;
    }
}

