/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.pipeline;

import java.util.Collection;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.pipeline.Pipeline;
import net.shibboleth.metadata.pipeline.PipelineProcessingException;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipelineCallable<T>
implements Callable<Collection<Item<T>>> {
    private final Logger log = LoggerFactory.getLogger(PipelineCallable.class);
    private Pipeline<T> pipeline;
    private Collection<Item<T>> itemCollection;

    public PipelineCallable(@Nonnull Pipeline<T> invokedPipeline, @Nonnull @NonnullElements Collection<Item<T>> items) {
        this.pipeline = (Pipeline)Constraint.isNotNull(invokedPipeline, (String)"To-be-invoked pipeline can not be null");
        Constraint.isTrue((boolean)invokedPipeline.isInitialized(), (String)"To-be-invoked pipeline must be initialized");
        this.itemCollection = (Collection)Constraint.isNotNull(items, (String)"Item collection can not be null");
    }

    @Override
    @Nonnull
    @NonnullElements
    public Collection<Item<T>> call() throws PipelineProcessingException {
        this.log.debug("Executing pipeline {} on an item collection containing {} items", (Object)this.pipeline.getId(), (Object)this.itemCollection.size());
        this.pipeline.execute(this.itemCollection);
        return this.itemCollection;
    }
}

