/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.pipeline;

import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.SimpleItemCollectionFactory;
import net.shibboleth.metadata.pipeline.BaseStage;
import net.shibboleth.metadata.pipeline.FutureSupport;
import net.shibboleth.metadata.pipeline.Pipeline;
import net.shibboleth.metadata.pipeline.PipelineCallable;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.collection.Pair;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;

@ThreadSafe
public class PipelineDemultiplexerStage<T>
extends BaseStage<T> {
    private ExecutorService executorService = Executors.newSingleThreadExecutor();
    private boolean waitingForPipelines;
    private Supplier<Collection<Item<T>>> collectionFactory = new SimpleItemCollectionFactory();
    private List<Pair<Pipeline<T>, Predicate<Item<T>>>> pipelineAndStrategies = Collections.emptyList();

    @Nonnull
    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public synchronized void setExecutorService(@Nonnull ExecutorService service) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.executorService = (ExecutorService)Constraint.isNotNull((Object)service, (String)"ExecutorService can not be null");
    }

    public boolean isWaitingForPipelines() {
        return this.waitingForPipelines;
    }

    public synchronized void setWaitingForPipelines(boolean isWaiting) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.waitingForPipelines = isWaiting;
    }

    @Nonnull
    public Supplier<Collection<Item<T>>> getCollectionFactory() {
        return this.collectionFactory;
    }

    public synchronized void setCollectionFactory(@Nonnull Supplier<Collection<Item<T>>> factory) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.collectionFactory = (Supplier)Constraint.isNotNull(factory, (String)"Collection factory can not be null");
    }

    @Nonnull
    @NonnullElements
    @Unmodifiable
    public List<Pair<Pipeline<T>, Predicate<Item<T>>>> getPipelineAndSelectionStrategies() {
        return this.pipelineAndStrategies;
    }

    public synchronized void setPipelineAndSelectionStrategies(@Nonnull @NonnullElements List<Pair<Pipeline<T>, Predicate<Item<T>>>> passes) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        if (passes == null || passes.isEmpty()) {
            this.pipelineAndStrategies = Collections.emptyList();
            return;
        }
        ImmutableList.Builder checkedPasses = new ImmutableList.Builder();
        for (Pair<Pipeline<T>, Predicate<Item<T>>> pass : passes) {
            Constraint.isNotNull((Object)pass.getFirst(), (String)"Pipeline can not be null");
            Constraint.isNotNull((Object)pass.getSecond(), (String)"Predicate can not be null");
            checkedPasses.add((Object)new Pair(pass));
        }
        this.pipelineAndStrategies = checkedPasses.build();
    }

    @Override
    protected void doExecute(@Nonnull @NonnullElements Collection<Item<T>> itemCollection) throws StageProcessingException {
        ArrayList pipelineFutures = new ArrayList();
        for (Pair<Pipeline<T>, Predicate<Item<T>>> pair : this.pipelineAndStrategies) {
            Pipeline pipeline = (Pipeline)pair.getFirst();
            Predicate selectionStrategy = (Predicate)pair.getSecond();
            Collection selectedItems = (Collection)this.collectionFactory.get();
            for (Item<T> item : itemCollection) {
                if (!selectionStrategy.apply(item)) continue;
                selectedItems.add(item.copy());
            }
            pipelineFutures.add(this.executorService.submit(new PipelineCallable(pipeline, selectedItems)));
        }
        if (this.isWaitingForPipelines()) {
            for (Future future : pipelineFutures) {
                FutureSupport.futureItems(future);
            }
        }
    }

    protected void doDestroy() {
        this.executorService = null;
        this.collectionFactory = null;
        this.pipelineAndStrategies = null;
        super.doDestroy();
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.pipelineAndStrategies.isEmpty()) {
            throw new ComponentInitializationException("Pipeline and selection strategy collection can not be null or empty");
        }
        for (Pair<Pipeline<T>, Predicate<Item<T>>> pipelineAndStrategy : this.pipelineAndStrategies) {
            Pipeline pipeline = (Pipeline)pipelineAndStrategy.getFirst();
            if (pipeline.isInitialized()) continue;
            pipeline.initialize();
        }
    }
}

