/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.pipeline;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.metadata.CollectionMergeStrategy;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.SimpleCollectionMergeStrategy;
import net.shibboleth.metadata.SimpleItemCollectionFactory;
import net.shibboleth.metadata.pipeline.BaseStage;
import net.shibboleth.metadata.pipeline.FutureSupport;
import net.shibboleth.metadata.pipeline.Pipeline;
import net.shibboleth.metadata.pipeline.PipelineCallable;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NullableElements;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;

@ThreadSafe
public class PipelineMergeStage<T>
extends BaseStage<T> {
    private ExecutorService executorService = Executors.newSingleThreadExecutor();
    private Supplier<Collection<Item<T>>> collectionFactory = new SimpleItemCollectionFactory();
    private CollectionMergeStrategy mergeStrategy = new SimpleCollectionMergeStrategy();
    private List<Pipeline<T>> mergedPipelines = Collections.emptyList();

    @Nonnull
    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public synchronized void setExecutorService(@Nonnull ExecutorService service) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.executorService = (ExecutorService)Constraint.isNotNull((Object)service, (String)"ExecutorService can not be null");
    }

    @Nonnull
    @NonnullElements
    @Unmodifiable
    public List<Pipeline<T>> getMergedPipelines() {
        return this.mergedPipelines;
    }

    public synchronized void setMergedPipelines(@Nullable @NullableElements List<? extends Pipeline<T>> pipelines) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.mergedPipelines = pipelines == null || pipelines.isEmpty() ? Collections.emptyList() : ImmutableList.copyOf((Iterable)Iterables.filter(pipelines, (Predicate)Predicates.notNull()));
    }

    @Nonnull
    public Supplier<Collection<Item<T>>> getCollectionFactory() {
        return this.collectionFactory;
    }

    public synchronized void setCollectionFactory(@Nonnull Supplier<Collection<Item<T>>> factory) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.collectionFactory = (Supplier)Constraint.isNotNull(factory, (String)"Collection factory may not be null");
    }

    @Nonnull
    public CollectionMergeStrategy getCollectionMergeStrategy() {
        return this.mergeStrategy;
    }

    public synchronized void setCollectionMergeStrategy(@Nonnull CollectionMergeStrategy strategy) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.mergeStrategy = strategy;
    }

    @Override
    protected void doExecute(@Nonnull @NonnullElements Collection<Item<T>> itemCollection) throws StageProcessingException {
        ArrayList<Future<T>> pipelineResultFutures = new ArrayList<Future<T>>();
        for (Pipeline<T> pipeline : this.mergedPipelines) {
            pipelineResultFutures.add(this.executorService.submit(new PipelineCallable<T>(pipeline, (Collection)this.collectionFactory.get())));
        }
        ArrayList pipelineResults = new ArrayList();
        for (Future future : pipelineResultFutures) {
            pipelineResults.add(FutureSupport.futureItems(future));
        }
        this.mergeStrategy.mergeCollection(itemCollection, pipelineResults);
    }

    protected void doDestroy() {
        this.executorService = null;
        this.collectionFactory = null;
        this.mergeStrategy = null;
        this.mergedPipelines = null;
        super.doDestroy();
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        for (Pipeline<T> pipeline : this.mergedPipelines) {
            if (pipeline.isInitialized()) continue;
            pipeline.initialize();
        }
    }
}

