/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.pipeline;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.metadata.CollectionMergeStrategy;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.SimpleCollectionMergeStrategy;
import net.shibboleth.metadata.SimpleItemCollectionFactory;
import net.shibboleth.metadata.pipeline.BaseStage;
import net.shibboleth.metadata.pipeline.FutureSupport;
import net.shibboleth.metadata.pipeline.Pipeline;
import net.shibboleth.metadata.pipeline.PipelineCallable;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class SplitMergeStage<T>
extends BaseStage<T> {
    private final Logger log = LoggerFactory.getLogger(SplitMergeStage.class);
    private ExecutorService executorService = Executors.newSingleThreadExecutor();
    private Supplier<Collection<Item<T>>> collectionFactory = new SimpleItemCollectionFactory();
    private Predicate<Item<T>> selectionStrategy = Predicates.alwaysFalse();
    private Pipeline<T> selectedItemPipeline;
    private Pipeline<T> nonselectedItemPipeline;
    private CollectionMergeStrategy mergeStrategy = new SimpleCollectionMergeStrategy();

    @Nonnull
    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public synchronized void setExecutorService(@Nonnull ExecutorService service) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.executorService = (ExecutorService)Constraint.isNotNull((Object)service, (String)"ExecutorService can not be null");
    }

    @Nonnull
    public Supplier<Collection<Item<T>>> getCollectionFactory() {
        return this.collectionFactory;
    }

    public synchronized void setCollectionFactory(@Nonnull Supplier<Collection<Item<T>>> factory) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.collectionFactory = (Supplier)Constraint.isNotNull(factory, (String)"Collection factory can not be null");
    }

    @Nonnull
    public Predicate<Item<T>> getSelectionStrategy() {
        return this.selectionStrategy;
    }

    public synchronized void setSelectionStrategy(@Nonnull Predicate<Item<T>> strategy) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.selectionStrategy = (Predicate)Constraint.isNotNull(strategy, (String)"Item selection strategy can not be null");
    }

    @Nullable
    public Pipeline<T> getSelectedItemPipeline() {
        return this.selectedItemPipeline;
    }

    public synchronized void setSelectedItemPipeline(@Nullable Pipeline<T> pipeline) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.selectedItemPipeline = pipeline;
    }

    @Nullable
    public Pipeline<T> getNonselectedItemPipeline() {
        return this.nonselectedItemPipeline;
    }

    public synchronized void setNonselectedItemPipeline(@Nullable Pipeline<T> pipeline) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.nonselectedItemPipeline = pipeline;
    }

    @Nonnull
    public CollectionMergeStrategy getCollectionMergeStrategy() {
        return this.mergeStrategy;
    }

    public synchronized void setCollectionMergeStrategy(@Nonnull CollectionMergeStrategy strategy) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.mergeStrategy = (CollectionMergeStrategy)Constraint.isNotNull((Object)strategy, (String)"Collection merge strategy can not be null");
    }

    @Override
    protected void doExecute(@Nonnull @NonnullElements Collection<Item<T>> itemCollection) throws StageProcessingException {
        Collection selectedItems = (Collection)this.collectionFactory.get();
        Collection nonselectedItems = (Collection)this.collectionFactory.get();
        for (Item<T> item : itemCollection) {
            if (item == null) continue;
            if (this.selectionStrategy.apply(item)) {
                selectedItems.add(item);
                continue;
            }
            nonselectedItems.add(item);
        }
        Future<Collection<Item<T>>> selectedItemFuture = this.executePipeline(this.selectedItemPipeline, selectedItems);
        Future<Collection<Item<T>>> nonselectedItemFuture = this.executePipeline(this.nonselectedItemPipeline, nonselectedItems);
        ArrayList pipelineResults = new ArrayList();
        pipelineResults.add(FutureSupport.futureItems(selectedItemFuture));
        pipelineResults.add(FutureSupport.futureItems(nonselectedItemFuture));
        itemCollection.clear();
        this.mergeStrategy.mergeCollection(itemCollection, pipelineResults);
    }

    @Nonnull
    protected Future<Collection<Item<T>>> executePipeline(Pipeline<T> pipeline, Collection<Item<T>> items) {
        if (pipeline == null) {
            return FutureSupport.futureNow(items);
        }
        PipelineCallable<T> callable = new PipelineCallable<T>(pipeline, items);
        return this.executorService.submit(callable);
    }

    protected void doDestroy() {
        this.executorService = null;
        this.collectionFactory = null;
        this.selectionStrategy = null;
        this.selectedItemPipeline = null;
        this.nonselectedItemPipeline = null;
        this.mergeStrategy = null;
        super.doDestroy();
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.selectedItemPipeline == null && this.nonselectedItemPipeline == null) {
            throw new ComponentInitializationException(this.getId() + " selected and non-selected pipelines are null");
        }
        if (this.selectedItemPipeline != null && !this.selectedItemPipeline.isInitialized()) {
            this.log.debug("Selected item pipeline was not initialized, initializing it now.");
            this.selectedItemPipeline.initialize();
        }
        if (this.nonselectedItemPipeline != null && !this.nonselectedItemPipeline.isInitialized()) {
            this.log.debug("Non-selected item pipeline was not initialized, initializing it now.");
            this.nonselectedItemPipeline.initialize();
        }
    }
}

