/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.pipeline;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.metadata.ErrorStatus;
import net.shibboleth.metadata.InfoStatus;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.ItemMetadata;
import net.shibboleth.metadata.StatusMetadata;
import net.shibboleth.metadata.WarningStatus;
import net.shibboleth.metadata.pipeline.AbstractItemMetadataSelectionStage;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class StatusMetadataLoggingStage<T>
extends AbstractItemMetadataSelectionStage<T> {
    private final Logger log = LoggerFactory.getLogger(StatusMetadataLoggingStage.class);

    @Override
    protected void doExecute(@Nonnull @NonnullElements Collection<Item<T>> itemCollection, @Nonnull Item<T> matchingItem, @Nonnull @NonnullElements Map<Class<? extends ItemMetadata>, List<? extends ItemMetadata>> matchingMetadata) throws StageProcessingException {
        String itemId = this.getItemIdentificationStrategy().getItemIdentifier(matchingItem);
        this.logInfos(itemId, matchingMetadata.get(InfoStatus.class));
        this.logWarnings(itemId, matchingMetadata.get(WarningStatus.class));
        this.logErrors(itemId, matchingMetadata.get(ErrorStatus.class));
    }

    private void logInfos(@Nonnull String itemId, @Nonnull @NonnullElements List<? extends ItemMetadata> statuses) {
        if (statuses != null && !statuses.isEmpty() && this.log.isInfoEnabled()) {
            this.log.info("Item {} was marked with the following Info status messages", (Object)itemId);
            for (ItemMetadata itemMetadata : statuses) {
                StatusMetadata status = (StatusMetadata)itemMetadata;
                this.log.info("    {}: {}", (Object)status.getComponentId(), (Object)status.getStatusMessage());
            }
        }
    }

    private void logWarnings(@Nonnull String itemId, @Nonnull @NonnullElements List<? extends ItemMetadata> statuses) {
        if (statuses != null && !statuses.isEmpty() && this.log.isWarnEnabled()) {
            this.log.warn("Item {} was marked with the following Warning status messages", (Object)itemId);
            for (ItemMetadata itemMetadata : statuses) {
                StatusMetadata status = (StatusMetadata)itemMetadata;
                this.log.warn("    {}: {}", (Object)status.getComponentId(), (Object)status.getStatusMessage());
            }
        }
    }

    private void logErrors(@Nonnull String itemId, @Nonnull @NonnullElements List<? extends ItemMetadata> statuses) {
        if (statuses != null && !statuses.isEmpty() && this.log.isErrorEnabled()) {
            this.log.error("Item {} was marked with the following Error status messages", (Object)itemId);
            for (ItemMetadata itemMetadata : statuses) {
                StatusMetadata status = (StatusMetadata)itemMetadata;
                this.log.error("    {}: {}", (Object)status.getComponentId(), (Object)status.getStatusMessage());
            }
        }
    }
}

