/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.util;

import java.util.Collection;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.ItemMetadata;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.collection.ClassToInstanceMultiMap;
import net.shibboleth.utilities.java.support.collection.LazyList;
import net.shibboleth.utilities.java.support.logic.Constraint;

public class ItemCollectionWithMetadata<T>
implements Collection<Item<T>> {
    private final Collection<Item<T>> delegate;
    private final ClassToInstanceMultiMap<ItemMetadata> metadata;

    public ItemCollectionWithMetadata() {
        this.delegate = new LazyList();
        this.metadata = new ClassToInstanceMultiMap(true);
    }

    public ItemCollectionWithMetadata(@Nonnull @NonnullElements Collection<Item<T>> wrappedCollection) {
        this.delegate = (Collection)Constraint.isNotNull(wrappedCollection, (String)"Wrapped collection can not be null");
        this.delegate.clear();
        this.metadata = new ClassToInstanceMultiMap(true);
    }

    @Nonnull
    @NonnullElements
    public ClassToInstanceMultiMap<ItemMetadata> getCollectionMetadata() {
        return this.metadata;
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.delegate.contains(o);
    }

    @Override
    @Nonnull
    @NonnullElements
    public Iterator<Item<T>> iterator() {
        return this.delegate.iterator();
    }

    @Override
    @Nonnull
    @NonnullElements
    public Object[] toArray() {
        return this.delegate.toArray();
    }

    @Override
    @Nonnull
    @NonnullElements
    public <TT> TT[] toArray(@Nonnull TT[] a) {
        Constraint.isNotNull(a, (String)"Target array can not be null");
        return this.delegate.toArray(a);
    }

    @Override
    public boolean add(@Nullable Item<T> e) {
        if (e == null) {
            return false;
        }
        return this.delegate.add(e);
    }

    @Override
    public boolean remove(@Nullable Object o) {
        if (o == null) {
            return false;
        }
        return this.delegate.remove(o);
    }

    @Override
    public boolean containsAll(@Nonnull Collection<?> c) {
        Constraint.isNotNull(c, (String)"Collection can not be null");
        return this.delegate.containsAll(c);
    }

    @Override
    public boolean addAll(@Nullable Collection<? extends Item<T>> c) {
        if (c == null) {
            return false;
        }
        return this.delegate.addAll(c);
    }

    @Override
    public boolean removeAll(@Nullable Collection<?> c) {
        if (c == null) {
            return false;
        }
        return this.delegate.removeAll(c);
    }

    @Override
    public boolean retainAll(@Nonnull Collection<?> c) {
        Constraint.isNotNull(c, (String)"Collection can not be null");
        return this.delegate.retainAll(c);
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }
}

