/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.util;

import java.util.Collection;
import javax.annotation.Nullable;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.ItemMetadata;
import net.shibboleth.metadata.util.ItemCollectionWithMetadata;
import net.shibboleth.utilities.java.support.annotation.constraint.NullableElements;

public final class ItemMetadataSupport {
    private ItemMetadataSupport() {
    }

    public static void addToAll(@Nullable Collection<? extends Item<?>> itemCollection, @Nullable @NullableElements Iterable<? extends ItemMetadata> metadatas) {
        if (itemCollection == null || metadatas == null) {
            return;
        }
        for (Item<?> item : itemCollection) {
            ItemMetadataSupport.addAll(item, metadatas);
        }
    }

    public static void addAll(@Nullable Item<?> item, @Nullable @NullableElements Iterable<? extends ItemMetadata> metadatas) {
        if (item == null || metadatas == null) {
            return;
        }
        for (ItemMetadata itemMetadata : metadatas) {
            if (itemMetadata == null) continue;
            item.getItemMetadata().put((Object)itemMetadata);
        }
    }

    public static <T> void addToCollection(@Nullable Collection<Item<T>> itemCollection, @Nullable @NullableElements Iterable<? extends ItemMetadata> itemMetadatas) {
        if (itemCollection == null || !(itemCollection instanceof ItemCollectionWithMetadata)) {
            return;
        }
        if (itemMetadatas == null) {
            return;
        }
        ItemCollectionWithMetadata collection = (ItemCollectionWithMetadata)itemCollection;
        for (ItemMetadata itemMetadata : itemMetadatas) {
            if (itemMetadata == null) continue;
            collection.getCollectionMetadata().put((Object)itemMetadata);
        }
    }
}

