/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.validate;

import javax.annotation.Nonnull;
import net.shibboleth.metadata.ErrorStatus;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.WarningStatus;
import net.shibboleth.utilities.java.support.component.AbstractIdentifiableInitializableComponent;

public abstract class BaseValidator
extends AbstractIdentifiableInitializableComponent {
    private String makeComponentId(@Nonnull String stageId) {
        String id = this.getId();
        if (id == null) {
            return stageId;
        }
        return stageId + "/" + this.getId();
    }

    protected void addError(@Nonnull String message, @Nonnull Item<?> item, @Nonnull String stageId) {
        item.getItemMetadata().put((Object)new ErrorStatus(this.makeComponentId(stageId), message));
    }

    protected void addWarning(@Nonnull String message, @Nonnull Item<?> item, @Nonnull String stageId) {
        item.getItemMetadata().put((Object)new WarningStatus(this.makeComponentId(stageId), message));
    }

    protected void addStatus(boolean error, @Nonnull String message, @Nonnull Item<?> item, @Nonnull String stageId) {
        if (error) {
            this.addError(message, item, stageId);
        } else {
            this.addWarning(message, item, stageId);
        }
    }
}

