/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.validate.x509;

import java.math.BigInteger;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.validate.x509.AbstractX509Validator;
import net.shibboleth.utilities.java.support.logic.Constraint;

@ThreadSafe
public class X509RSAExponentValidator
extends AbstractX509Validator {
    private BigInteger errorBoundary = BigInteger.valueOf(5L);
    private BigInteger warningBoundary = BigInteger.ZERO;

    public X509RSAExponentValidator() {
        this.setId("RSAExponent");
    }

    public long getErrorBoundary() {
        return this.errorBoundary.longValue();
    }

    public void setErrorBoundary(long length) {
        Constraint.isGreaterThanOrEqual((long)0L, (long)length, (String)"boundary value must not be negative");
        this.errorBoundary = BigInteger.valueOf(length);
    }

    public long getWarningBoundary() {
        return this.warningBoundary.longValue();
    }

    public void setWarningBoundary(long length) {
        Constraint.isGreaterThanOrEqual((long)0L, (long)length, (String)"boundary value must not be negative");
        this.warningBoundary = BigInteger.valueOf(length);
    }

    @Override
    public void doValidate(@Nonnull X509Certificate cert, @Nonnull Item<?> item, @Nonnull String stageId) {
        PublicKey key = cert.getPublicKey();
        if ("RSA".equals(key.getAlgorithm())) {
            RSAPublicKey rsaKey = (RSAPublicKey)key;
            BigInteger exponent = rsaKey.getPublicExponent();
            if (!exponent.testBit(0)) {
                this.addError("RSA public exponent of " + exponent + " must be odd", item, stageId);
            } else if (exponent.compareTo(this.errorBoundary) < 0) {
                this.addError("RSA public exponent of " + exponent + " is less than required " + this.errorBoundary, item, stageId);
            } else if (exponent.compareTo(this.warningBoundary) < 0) {
                this.addWarning("RSA public exponent of " + exponent + " is less than recommended " + this.warningBoundary, item, stageId);
            }
        }
    }
}

