/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.validate.x509;

import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.validate.x509.AbstractX509Validator;

@ThreadSafe
public class X509RSAKeyLengthValidator
extends AbstractX509Validator {
    private int errorBoundary = 2048;
    private int warningBoundary;

    public X509RSAKeyLengthValidator() {
        this.setId("RSAKeyLength");
    }

    public int getErrorBoundary() {
        return this.errorBoundary;
    }

    public void setErrorBoundary(int length) {
        this.errorBoundary = length;
    }

    public int getWarningBoundary() {
        return this.warningBoundary;
    }

    public void setWarningBoundary(int length) {
        this.warningBoundary = length;
    }

    @Override
    public void doValidate(@Nonnull X509Certificate cert, @Nonnull Item<?> item, @Nonnull String stageId) {
        PublicKey key = cert.getPublicKey();
        if ("RSA".equals(key.getAlgorithm())) {
            RSAPublicKey rsaKey = (RSAPublicKey)key;
            int keyLen = rsaKey.getModulus().bitLength();
            if (keyLen < this.errorBoundary) {
                this.addError("RSA key length of " + keyLen + " bits is less than required " + this.errorBoundary, item, stageId);
            } else if (keyLen < this.warningBoundary) {
                this.addWarning("RSA key length of " + keyLen + " bits is less than recommended " + this.warningBoundary, item, stageId);
            }
        }
    }
}

