/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.validate.x509;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import net.shibboleth.metadata.validate.x509.AbstractX509Validator;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.apache.commons.codec.binary.Hex;
import org.springframework.core.io.Resource;

@ThreadSafe
public class X509RSAOpenSSLBlacklistValidator
extends AbstractX509Validator {
    private final byte[] openSSLprefix = new byte[]{77, 111, 100, 117, 108, 117, 115, 61};
    private Resource blacklistResource;
    private int keySize;
    private final Set<String> blacklistedValues = new HashSet<String>();

    public X509RSAOpenSSLBlacklistValidator() {
        this.setId("OpenSSLBlacklist");
    }

    @Nullable
    public Resource getBlacklistResource() {
        return this.blacklistResource;
    }

    public synchronized void setBlacklistResource(@Nonnull Resource resource) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.blacklistResource = (Resource)Constraint.isNotNull((Object)resource, (String)"blacklist resource can not be null");
    }

    public void setKeySize(int size) {
        this.keySize = size;
    }

    public int getKeySize() {
        return this.keySize;
    }

    @Nonnull
    private String openSSLDigest(@Nonnull BigInteger modulus) throws StageProcessingException {
        try {
            byte[] modulusBytes = modulus.toByteArray();
            if (modulusBytes[0] == 0) {
                modulusBytes = Arrays.copyOfRange(modulusBytes, 1, modulusBytes.length);
            }
            char[] encodedModulus = Hex.encodeHex((byte[])modulusBytes, (boolean)false);
            ByteArrayOutputStream bb = new ByteArrayOutputStream();
            try {
                bb.write(this.openSSLprefix);
                for (char c : encodedModulus) {
                    bb.write((byte)c);
                }
                bb.write(10);
            }
            catch (IOException e) {
                throw new StageProcessingException("internal error writing to ByteArrayStream", e);
            }
            MessageDigest digest = MessageDigest.getInstance("SHA1");
            digest.update(bb.toByteArray());
            byte[] bytes = digest.digest();
            char[] encodedDigest = Hex.encodeHex((byte[])bytes, (boolean)true);
            String strValue = String.valueOf(encodedDigest);
            String trimmed = strValue.substring(20);
            return trimmed;
        }
        catch (NoSuchAlgorithmException e) {
            throw new StageProcessingException("could not create message digester", e);
        }
    }

    @Override
    public void doValidate(@Nonnull X509Certificate cert, @Nonnull Item<?> item, @Nonnull String stageId) throws StageProcessingException {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        PublicKey key = cert.getPublicKey();
        if ("RSA".equals(key.getAlgorithm())) {
            String value;
            RSAPublicKey rsaKey = (RSAPublicKey)key;
            BigInteger modulus = rsaKey.getModulus();
            if ((this.keySize == 0 || this.keySize == modulus.bitLength()) && this.blacklistedValues.contains(value = this.openSSLDigest(modulus))) {
                this.addError("RSA modulus included in key blacklist (" + value + ")", item, stageId);
            }
        }
    }

    protected void doDestroy() {
        this.blacklistResource = null;
        this.blacklistedValues.clear();
        super.doDestroy();
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.blacklistResource == null) {
            throw new ComponentInitializationException("Unable to initialize " + this.getId() + ", blacklistResource must not be null");
        }
        if (!this.blacklistResource.exists()) {
            throw new ComponentInitializationException("Unable to initialize " + this.getId() + ", blacklistResource " + this.blacklistResource.getDescription() + " does not exist");
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.blacklistResource.getInputStream()));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.trim().length() == 0 || line.charAt(0) == '#') continue;
                this.blacklistedValues.add(line);
            }
        }
        catch (IOException e) {
            throw new ComponentInitializationException("Unable to initialize " + this.getId() + ", error reading blacklistResource " + this.blacklistResource.getDescription() + " information", (Exception)e);
        }
    }
}

