/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.spring.metadata;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.xml.AttributeSupport;
import net.shibboleth.shared.xml.ElementSupport;
import net.shibboleth.spring.http.HttpClientFactoryBean;
import net.shibboleth.spring.metadata.AbstractReloadingMetadataProviderParser;
import net.shibboleth.spring.metadata.HTTPMetadataProvidersParserSupport;
import org.slf4j.Logger;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class HTTPMetadataProviderParser
extends AbstractReloadingMetadataProviderParser {
    @Nonnull
    private static final Class<?> DEFAULT_CLIENT_CLASS = HttpClientFactoryBean.class;
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(HTTPMetadataProviderParser.class);

    @Override
    protected void doNativeParse(@Nonnull Element element, @Nonnull ParserContext parserContext, @Nonnull BeanDefinitionBuilder builder) {
        super.doNativeParse(element, parserContext, builder);
        Element tlsTrustEngine = ElementSupport.getFirstChildElement((Node)element, (QName)HTTPMetadataProvidersParserSupport.TLS_TRUST_ENGINE_ELEMENT_NAME);
        String httpClientSecurityParametersRef = StringSupport.trimOrNull((String)element.getAttributeNS(null, "httpClientSecurityParametersRef"));
        BeanDefinition httpClientSecurityParameters = null;
        if (httpClientSecurityParametersRef != null) {
            if (tlsTrustEngine != null) {
                this.log.warn("httpClientSecurityParametersRef overrides <TrustEngine> subelement");
            }
            builder.addPropertyReference("httpClientSecurityParameters", httpClientSecurityParametersRef);
        } else if (tlsTrustEngine != null) {
            httpClientSecurityParameters = HTTPMetadataProvidersParserSupport.parseTLSTrustEngine(tlsTrustEngine, parserContext);
            builder.addPropertyValue("httpClientSecurityParameters", (Object)httpClientSecurityParameters);
        }
        if (element.hasAttributeNS(null, "httpClientRef")) {
            builder.addConstructorArgReference(AttributeSupport.ensureAttributeValue((Element)element, null, (String)"httpClientRef"));
            if (element.hasAttributeNS(null, "connectionTimeout") || element.hasAttributeNS(null, "connectionRequestTimeout") || element.hasAttributeNS(null, "socketTimeout") || element.hasAttributeNS(null, "disregardTLSCertificate") || element.hasAttributeNS(null, "proxyHost") || element.hasAttributeNS(null, "proxyPort") || element.hasAttributeNS(null, "proxyUser") || element.hasAttributeNS(null, "proxyPassword")) {
                this.log.warn("httpClientRef overrides settings for connectionTimeout, connectionRequestTimeout, socketTimeout, disregardTLSCertificate,  proxyHost, proxyPort, proxyUser and proxyPassword");
            }
        } else {
            builder.addConstructorArgValue((Object)this.buildHttpClient(element, parserContext, httpClientSecurityParametersRef, httpClientSecurityParameters));
        }
        builder.addConstructorArgValue((Object)StringSupport.trimOrNull((String)element.getAttributeNS(null, "metadataURL")));
    }

    @Nonnull
    private BeanDefinition buildHttpClient(@Nonnull Element element, @Nonnull ParserContext parserContext, @Nullable String httpClientSecurityParametersRef, @Nullable BeanDefinition httpClientSecurityParameters) {
        return HTTPMetadataProvidersParserSupport.buildCommonClientBuilder(element, parserContext, DEFAULT_CLIENT_CLASS, httpClientSecurityParametersRef, httpClientSecurityParameters).getBeanDefinition();
    }
}

