/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.spring.metadata;

import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import org.opensaml.saml.metadata.resolver.ChainingMetadataResolver;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.metadata.resolver.filter.MetadataFilter;
import org.opensaml.saml.metadata.resolver.filter.MetadataFilterChain;
import org.opensaml.saml.metadata.resolver.filter.MetadataNodeProcessor;
import org.opensaml.saml.metadata.resolver.filter.impl.NodeProcessingMetadataFilter;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.Ordered;

public class NodeProcessingAttachingBeanPostProcessor
implements BeanPostProcessor,
Ordered {
    @Nonnull
    private List<MetadataNodeProcessor> nodeProcessors;

    @Autowired
    public NodeProcessingAttachingBeanPostProcessor(@Nullable Collection<MetadataNodeProcessor> processors) {
        this.nodeProcessors = processors != null ? CollectionSupport.copyToList(processors) : CollectionSupport.emptyList();
    }

    public void setNodeProcessors(@Nullable Collection<MetadataNodeProcessor> processors) {
        if (processors != null) {
            this.nodeProcessors = CollectionSupport.copyToList(processors);
        }
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    @Nonnull
    public Object postProcessBeforeInitialization(@Nonnull Object bean, @Nonnull String beanName) {
        if (this.nodeProcessors.isEmpty()) {
            return bean;
        }
        if (!(bean instanceof MetadataResolver) || bean instanceof ChainingMetadataResolver) {
            return bean;
        }
        MetadataResolver resolver = (MetadataResolver)bean;
        NodeProcessingMetadataFilter filterToAttach = new NodeProcessingMetadataFilter();
        filterToAttach.setNodeProcessors(this.nodeProcessors);
        try {
            filterToAttach.initialize();
        }
        catch (ComponentInitializationException e) {
            throw new BeanCreationException("Error initializing NodeProcessingMetadataFilter", (Throwable)e);
        }
        MetadataFilter filter = resolver.getMetadataFilter();
        if (filter == null) {
            resolver.setMetadataFilter((MetadataFilter)filterToAttach);
        } else if (filter instanceof MetadataFilterChain) {
            ((MetadataFilterChain)filter).getFilters().add(filterToAttach);
        } else {
            MetadataFilterChain chain = new MetadataFilterChain();
            chain.setFilters(CollectionSupport.listOf((Object)filter, (Object)filterToAttach));
            resolver.setMetadataFilter((MetadataFilter)chain);
        }
        return resolver;
    }

    @Nonnull
    public Object postProcessAfterInitialization(@Nonnull Object bean, @Nonnull String beanName) {
        return bean;
    }
}

