/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.spring.metadata.filter;

import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.shared.logic.PredicateSupport;
import net.shibboleth.shared.logic.ScriptedPredicate;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.spring.util.SpringSupport;
import net.shibboleth.shared.xml.AttributeSupport;
import net.shibboleth.shared.xml.ElementSupport;
import net.shibboleth.spring.ScriptTypeBeanParser;
import net.shibboleth.spring.metadata.filter.AbstractMetadataFilterParser;
import net.shibboleth.spring.metadata.filter.PredicateFilterDirectionFactoryBean;
import org.opensaml.saml.common.profile.logic.EntityAttributesPredicate;
import org.opensaml.saml.common.profile.logic.EntityGroupNamePredicate;
import org.opensaml.saml.common.profile.logic.EntityIdPredicate;
import org.opensaml.saml.metadata.resolver.filter.impl.PredicateFilter;
import org.slf4j.Logger;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PredicateFilterParser
extends AbstractMetadataFilterParser {
    @Nonnull
    public static final QName TYPE_NAME = new QName("urn:mace:shibboleth:2.0:metadata", "Predicate");
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(PredicateFilterParser.class);
    @Nullable
    private Class<? extends Predicate<?>> mappedPredicateClass;

    public PredicateFilterParser() {
        try {
            String className = PredicateFilterParser.getCustomProperty((String)(((Object)((Object)this)).getClass().getName() + ".MappedPredicate.class"), null);
            if (className != null) {
                this.mappedPredicateClass = Class.forName(className);
                this.log.debug("Using class for mapped tag predicate: {}", (Object)className);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    @Nonnull
    protected Class<?> getBeanClass(@Nonnull Element element) {
        return PredicateFilter.class;
    }

    @Override
    protected void doParse(@Nonnull Element element, @Nonnull ParserContext parserContext, @Nonnull BeanDefinitionBuilder builder) {
        super.doParse(element, parserContext, builder);
        if (element.hasAttributeNS(null, "removeEmptyEntitiesDescriptors")) {
            builder.addPropertyValue("removeEmptyEntitiesDescriptors", (Object)SpringSupport.getStringValueAsBoolean((String)element.getAttributeNS(null, "removeEmptyEntitiesDescriptors")));
        }
        BeanDefinitionBuilder directionBuilder = BeanDefinitionBuilder.genericBeanDefinition(PredicateFilterDirectionFactoryBean.class);
        directionBuilder.addConstructorArgValue((Object)StringSupport.trimOrNull((String)element.getAttributeNS(null, "direction")));
        builder.addConstructorArgValue((Object)directionBuilder.getBeanDefinition());
        if (element.hasAttributeNS(null, "conditionRef")) {
            this.log.info("Found conditionRef attribute, ignoring embedded Entity/Group/Tag elements");
            builder.addConstructorArgReference(AttributeSupport.ensureAttributeValue((Element)element, null, (String)"conditionRef"));
        } else {
            builder.addConstructorArgValue((Object)this.parseCustomElements(element));
        }
    }

    @Nonnull
    public BeanDefinition parseCustomElements(@Nonnull Element element) {
        BeanDefinitionBuilder entityIdPredicateBuilder = this.parseEntityPredicate(element);
        BeanDefinitionBuilder groupPredicateBuilder = this.parseGroupPredicate(element);
        BeanDefinitionBuilder tagPredicateBuilder = this.parseTagPredicate(element);
        BeanDefinitionBuilder mappedTagPredicateBuilder = this.parseMappedTagPredicate(element);
        BeanDefinitionBuilder scriptPredicateBuilder = this.parseScripts(element);
        int count = 0;
        if (entityIdPredicateBuilder != null) {
            ++count;
        }
        if (groupPredicateBuilder != null) {
            ++count;
        }
        if (tagPredicateBuilder != null) {
            ++count;
        }
        if (mappedTagPredicateBuilder != null) {
            ++count;
        }
        if (scriptPredicateBuilder != null) {
            ++count;
        }
        if (count == 0) {
            throw new BeanCreationException("No Entity, Group, Tag, or ConditionScript element found");
        }
        if (count == 1) {
            if (entityIdPredicateBuilder != null) {
                return entityIdPredicateBuilder.getBeanDefinition();
            }
            if (groupPredicateBuilder != null) {
                return groupPredicateBuilder.getBeanDefinition();
            }
            if (tagPredicateBuilder != null) {
                return tagPredicateBuilder.getBeanDefinition();
            }
            if (mappedTagPredicateBuilder != null) {
                return mappedTagPredicateBuilder.getBeanDefinition();
            }
            if (scriptPredicateBuilder != null) {
                return scriptPredicateBuilder.getBeanDefinition();
            }
            throw new BeanCreationException("No Entity, Group, Tag, or ConditionScript element found");
        }
        BeanDefinitionBuilder orBuilder = BeanDefinitionBuilder.rootBeanDefinition(PredicateSupport.class, (String)"or");
        ManagedList managedList = new ManagedList(count);
        if (entityIdPredicateBuilder != null) {
            managedList.add((Object)entityIdPredicateBuilder.getBeanDefinition());
        }
        if (groupPredicateBuilder != null) {
            managedList.add((Object)groupPredicateBuilder.getBeanDefinition());
        }
        if (tagPredicateBuilder != null) {
            managedList.add((Object)tagPredicateBuilder.getBeanDefinition());
        }
        if (mappedTagPredicateBuilder != null) {
            managedList.add((Object)mappedTagPredicateBuilder.getBeanDefinition());
        }
        if (scriptPredicateBuilder != null) {
            managedList.add((Object)scriptPredicateBuilder.getBeanDefinition());
        }
        orBuilder.addConstructorArgValue((Object)managedList);
        return orBuilder.getBeanDefinition();
    }

    @Nullable
    public BeanDefinitionBuilder parseEntityPredicate(@Nonnull Element element) {
        List entityList = ElementSupport.getChildElementsByTagNameNS((Node)element, (String)"urn:mace:shibboleth:2.0:metadata", (String)"Entity");
        if (!entityList.isEmpty()) {
            ManagedList managedEntityList = SpringSupport.getElementTextContentAsManagedList((Collection)entityList);
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(EntityIdPredicate.class);
            builder.addConstructorArgValue((Object)managedEntityList);
            return builder;
        }
        return null;
    }

    @Nullable
    public BeanDefinitionBuilder parseGroupPredicate(@Nonnull Element element) {
        List groupList = ElementSupport.getChildElementsByTagNameNS((Node)element, (String)"urn:mace:shibboleth:2.0:metadata", (String)"Group");
        if (!groupList.isEmpty()) {
            ManagedList managedGroupList = SpringSupport.getElementTextContentAsManagedList((Collection)groupList);
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(EntityGroupNamePredicate.class);
            builder.addConstructorArgValue((Object)managedGroupList);
            return builder;
        }
        return null;
    }

    @Nullable
    public BeanDefinitionBuilder parseTagPredicate(@Nonnull Element element) {
        List tagList = ElementSupport.getChildElementsByTagNameNS((Node)element, (String)"urn:mace:shibboleth:2.0:metadata", (String)"Tag");
        if (!tagList.isEmpty()) {
            ManagedList managedTagList = new ManagedList(tagList.size());
            for (Element tag : tagList) {
                BeanDefinitionBuilder tagBuilder = BeanDefinitionBuilder.genericBeanDefinition(EntityAttributesPredicate.Candidate.class);
                tagBuilder.addConstructorArgValue((Object)StringSupport.trimOrNull((String)tag.getAttributeNS(null, "name")));
                tagBuilder.addConstructorArgValue((Object)StringSupport.trimOrNull((String)tag.getAttributeNS(null, "nameFormat")));
                List valueList = ElementSupport.getChildElementsByTagNameNS((Node)tag, (String)"urn:mace:shibboleth:2.0:metadata", (String)"Value");
                if (!valueList.isEmpty()) {
                    ManagedList managedValueList = SpringSupport.getElementTextContentAsManagedList((Collection)valueList);
                    tagBuilder.addPropertyValue("values", (Object)managedValueList);
                }
                managedTagList.add((Object)tagBuilder.getBeanDefinition());
            }
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(EntityAttributesPredicate.class);
            builder.addConstructorArgValue((Object)managedTagList);
            builder.addConstructorArgValue((Object)SpringSupport.getStringValueAsBoolean((String)element.getAttributeNS(null, "trim")));
            return builder;
        }
        return null;
    }

    @Nullable
    public BeanDefinitionBuilder parseMappedTagPredicate(@Nonnull Element element) {
        List tagList = ElementSupport.getChildElementsByTagNameNS((Node)element, (String)"urn:mace:shibboleth:2.0:metadata", (String)"MappedTag");
        if (!tagList.isEmpty()) {
            if (this.mappedPredicateClass == null) {
                this.log.warn("Ignoring MappedTag element(s), no predicate class configured");
                return null;
            }
            ManagedList managedTagList = new ManagedList(tagList.size());
            for (Element tag : tagList) {
                BeanDefinitionBuilder tagBuilder = BeanDefinitionBuilder.genericBeanDefinition(EntityAttributesPredicate.Candidate.class);
                tagBuilder.addConstructorArgValue((Object)StringSupport.trimOrNull((String)tag.getAttributeNS(null, "name")));
                List valueList = ElementSupport.getChildElementsByTagNameNS((Node)tag, (String)"urn:mace:shibboleth:2.0:metadata", (String)"Value");
                if (!valueList.isEmpty()) {
                    ManagedList managedValueList = SpringSupport.getElementTextContentAsManagedList((Collection)valueList);
                    tagBuilder.addPropertyValue("values", (Object)managedValueList);
                }
                managedTagList.add((Object)tagBuilder.getBeanDefinition());
            }
            assert (this.mappedPredicateClass != null);
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(this.mappedPredicateClass);
            builder.addConstructorArgValue((Object)managedTagList);
            builder.addConstructorArgValue((Object)StringSupport.trimOrNull((String)element.getAttributeNS(null, "trim")));
            return builder;
        }
        return null;
    }

    @Nullable
    public BeanDefinitionBuilder parseScripts(@Nonnull Element element) {
        List scriptList = ElementSupport.getChildElementsByTagNameNS((Node)element, (String)"urn:mace:shibboleth:2.0:metadata", (String)"ConditionScript");
        if (scriptList.isEmpty()) {
            return null;
        }
        if (scriptList.size() == 1) {
            return ScriptTypeBeanParser.parseScriptType(ScriptedPredicate.class, (Element)scriptList.get(0));
        }
        BeanDefinitionBuilder orBuilder = BeanDefinitionBuilder.rootBeanDefinition(PredicateSupport.class, (String)"or");
        ManagedList managedList = new ManagedList(scriptList.size());
        for (Element e : scriptList) {
            assert (e != null);
            managedList.add((Object)ScriptTypeBeanParser.parseScriptType(ScriptedPredicate.class, e).getBeanDefinition());
        }
        orBuilder.addConstructorArgValue((Object)managedList);
        return orBuilder;
    }

    protected boolean shouldGenerateId() {
        return true;
    }
}

