/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.spring.security.trust;

import javax.annotation.Nonnull;
import javax.xml.namespace.QName;
import net.shibboleth.spring.security.trust.AbstractStaticPKIXParser;
import org.opensaml.xmlsec.config.impl.DefaultSecurityConfigurationBootstrap;
import org.opensaml.xmlsec.signature.support.impl.PKIXSignatureTrustEngine;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class StaticPKIXSignatureParser
extends AbstractStaticPKIXParser {
    @Nonnull
    public static final QName TYPE_NAME = new QName("urn:mace:shibboleth:2.0:security", "StaticPKIXSignature");

    @Nonnull
    protected Class<?> getBeanClass(@Nonnull Element element) {
        return PKIXSignatureTrustEngine.class;
    }

    @Override
    protected void doParse(@Nonnull Element element, @Nonnull ParserContext parserContext, @Nonnull BeanDefinitionBuilder builder) {
        super.doParse(element, parserContext, builder);
        builder.addConstructorArgValue((Object)this.getPKIXValidationInformationResolver(element, parserContext));
        builder.addConstructorArgValue((Object)DefaultSecurityConfigurationBootstrap.buildBasicInlineKeyInfoCredentialResolver());
        builder.addConstructorArgValue((Object)this.getPKIXTrustEvaluator(element, parserContext));
        builder.addConstructorArgValue(this.getX509CredentialNameEvaluator(element, parserContext));
    }
}

