/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.spring.metadata;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.spring.util.SpringSupport;
import net.shibboleth.shared.xml.AttributeSupport;
import net.shibboleth.shared.xml.ElementSupport;
import net.shibboleth.spring.http.InMemoryCachingHttpClientFactoryBean;
import net.shibboleth.spring.metadata.AbstractDynamicMetadataProviderParser;
import net.shibboleth.spring.metadata.HTTPMetadataProvidersParserSupport;
import org.slf4j.Logger;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class AbstractDynamicHTTPMetadataProviderParser
extends AbstractDynamicMetadataProviderParser {
    @Nonnull
    private static final Class<?> DEFAULT_CACHING_CLASS = InMemoryCachingHttpClientFactoryBean.class;
    @Nonnull
    private static final Integer DEFAULT_MAX_CONNECTIONS_TOTAL = 100;
    @Nonnull
    private static final Integer DEFAULT_MAX_CONNECTIONS_PER_ROUTE = 100;
    @Nonnull
    @NotEmpty
    private static final String DEFAULT_CONNECTION_REQUEST_TIMEOUT = "PT5S";
    @Nonnull
    @NotEmpty
    private static final String DEFAULT_CONNECTION_TIMEOUT = "PT5S";
    @Nonnull
    @NotEmpty
    private static final String DEFAULT_SOCKET_TIMEOUT = "PT5S";
    private final Logger log = LoggerFactory.getLogger(AbstractDynamicHTTPMetadataProviderParser.class);

    @Override
    protected void doNativeParse(@Nonnull Element element, @Nonnull ParserContext parserContext, @Nonnull BeanDefinitionBuilder builder) {
        super.doNativeParse(element, parserContext, builder);
        BeanDefinition httpClientSecurityParameters = HTTPMetadataProvidersParserSupport.buildHttpClientSecurityParameters(ElementSupport.getFirstChildElement((Node)element, (QName)HTTPMetadataProvidersParserSupport.TLS_TRUST_ENGINE_ELEMENT_NAME), StringSupport.trimOrNull((String)element.getAttributeNS(null, "httpClientSecurityParametersRef")), parserContext);
        builder.addPropertyValue("httpClientSecurityParameters", (Object)httpClientSecurityParameters);
        if (element.hasAttributeNS(null, "httpClientRef")) {
            builder.addConstructorArgReference(AttributeSupport.ensureAttributeValue((Element)element, null, (String)"httpClientRef"));
            if (element.hasAttributeNS(null, "connectionTimeout") || element.hasAttributeNS(null, "connectionRequestTimeout") || element.hasAttributeNS(null, "socketTimeout") || element.hasAttributeNS(null, "maxConnectionsTotal") || element.hasAttributeNS(null, "maxConnectionsPerRoute") || element.hasAttributeNS(null, "disregardTLSCertificate") || element.hasAttributeNS(null, "proxyHost") || element.hasAttributeNS(null, "proxyPort") || element.hasAttributeNS(null, "proxyUser") || element.hasAttributeNS(null, "proxyPassword")) {
                this.log.warn("httpClientRef overrides settings for connectionTimeout, connectionRequestTimeout, socketTimeout, maxConnectionsTotal, maxConnectionsPerRoute, disregardTLSCertificate, proxyHost, proxyPort, proxyUser and proxyPassword");
            }
        } else {
            builder.addConstructorArgValue((Object)this.buildHttpClient(element, parserContext, httpClientSecurityParameters));
        }
        if (element.hasAttributeNS(null, "supportedContentTypes")) {
            AbstractBeanDefinition listBuilder = SpringSupport.getAttributeValueAsList((Attr)element.getAttributeNodeNS(null, "supportedContentTypes"));
            builder.addPropertyValue("supportedContentTypes", (Object)listBuilder);
        }
    }

    @Nonnull
    private BeanDefinition buildHttpClient(@Nonnull Element element, @Nonnull ParserContext parserContext, @Nullable BeanDefinition httpClientSecurityParameters) {
        BeanDefinitionBuilder clientBuilder = HTTPMetadataProvidersParserSupport.buildCommonClientBuilder(element, parserContext, DEFAULT_CACHING_CLASS, httpClientSecurityParameters);
        if (!element.hasAttributeNS(null, "connectionTimeout")) {
            clientBuilder.addPropertyValue("connectionTimeout", (Object)"PT5S");
        }
        if (!element.hasAttributeNS(null, "connectionRequestTimeout")) {
            clientBuilder.addPropertyValue("connectionRequestTimeout", (Object)"PT5S");
        }
        if (!element.hasAttributeNS(null, "socketTimeout")) {
            clientBuilder.addPropertyValue("socketTimeout", (Object)"PT5S");
        }
        if (element.hasAttributeNS(null, "maxConnectionsTotal")) {
            clientBuilder.addPropertyValue("maxConnectionsTotal", (Object)StringSupport.trimOrNull((String)element.getAttributeNS(null, "maxConnectionsTotal")));
        } else {
            clientBuilder.addPropertyValue("maxConnectionsTotal", (Object)DEFAULT_MAX_CONNECTIONS_TOTAL);
        }
        if (element.hasAttributeNS(null, "maxConnectionsPerRoute")) {
            clientBuilder.addPropertyValue("maxConnectionsPerRoute", (Object)StringSupport.trimOrNull((String)element.getAttributeNS(null, "maxConnectionsPerRoute")));
        } else {
            clientBuilder.addPropertyValue("maxConnectionsPerRoute", (Object)DEFAULT_MAX_CONNECTIONS_PER_ROUTE);
        }
        return clientBuilder.getBeanDefinition();
    }
}

