/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.spring.security.credential;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.spring.util.SpringSupport;
import net.shibboleth.shared.xml.AttributeSupport;
import net.shibboleth.shared.xml.ElementSupport;
import net.shibboleth.spring.security.credential.AbstractCredentialParser;
import org.slf4j.Logger;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class AbstractX509CredentialParser
extends AbstractCredentialParser {
    @Nonnull
    public static final QName PRIVATE_KEY_ELEMENT_NAME = new QName("urn:mace:shibboleth:2.0:security", "PrivateKey");
    @Nonnull
    public static final QName CERTIFICATE_ELEMENT_NAME = new QName("urn:mace:shibboleth:2.0:security", "Certificate");
    @Nonnull
    public static final QName CRL_ELEMENT_NAME = new QName("urn:mace:shibboleth:2.0:security", "CRL");
    @Nonnull
    private Logger log = LoggerFactory.getLogger(AbstractX509CredentialParser.class);

    protected void doParse(@Nonnull Element element, @Nonnull BeanDefinitionBuilder builder) {
        super.doParse(element, builder);
        this.parsePrivateKey(ElementSupport.getChildElements((Node)element, (QName)PRIVATE_KEY_ELEMENT_NAME), builder);
        this.parseCertificates(ElementSupport.getChildElements((Node)element, (QName)CERTIFICATE_ELEMENT_NAME), builder);
        this.parseCRLs(ElementSupport.getChildElements((Node)element, (QName)CRL_ELEMENT_NAME), builder);
    }

    private void parsePrivateKey(@Nullable List<Element> childElements, @Nonnull BeanDefinitionBuilder builder) {
        if (null == childElements || childElements.isEmpty()) {
            return;
        }
        if (childElements.size() > 1) {
            throw new BeanCreationException("More than one <PrivateKey> Elements present.");
        }
        Element key = childElements.get(0);
        String value = StringSupport.trimOrNull((String)key.getTextContent());
        if (null == value) {
            throw new BeanCreationException("<PrivateKey> Must contain text.");
        }
        this.log.debug("Found a private key <Supressed>");
        builder.addPropertyValue("privateKey", (Object)value);
        builder.addPropertyValue("privateKeyPassword", (Object)key.getAttributeNS(null, "password"));
    }

    private void parseCertificates(@Nullable List<Element> childElements, @Nonnull BeanDefinitionBuilder builder) {
        if (null == childElements || childElements.isEmpty()) {
            throw new BeanCreationException("At least one <Certificate> should be present.");
        }
        ManagedList certs = new ManagedList(childElements.size());
        for (Element elem : childElements) {
            String cert = StringSupport.trimOrNull((String)elem.getTextContent());
            if (null == cert) {
                throw new BeanCreationException("All <Certificate> elements must contain text.");
            }
            if (elem.hasAttributeNS(null, "entityCertificate")) {
                Boolean flag = AttributeSupport.getAttributeValueAsBoolean((Attr)elem.getAttributeNodeNS(null, "entityCertificate"));
                if (flag != null && flag.booleanValue()) {
                    this.log.debug("Found a certficate marked as an entityCertificate {}", (Object)cert);
                    builder.addPropertyValue("entity", (Object)cert);
                }
            } else {
                this.log.debug("Found a certficate {}", (Object)cert);
            }
            certs.add(cert);
        }
        builder.addPropertyValue("certificates", (Object)certs);
    }

    private void parseCRLs(@Nullable List<Element> childElements, @Nonnull BeanDefinitionBuilder builder) {
        if (null == childElements || childElements.isEmpty()) {
            return;
        }
        builder.addPropertyValue("CRLs", (Object)SpringSupport.getElementTextContentAsManagedList(childElements));
    }
}

