/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.shibboleth.spring.http;

import net.shibboleth.saml.metadata.Version;

/**
 * Factory bean customization for the Shibboleth IdP.
 */
public class HttpClientFactoryBean extends net.shibboleth.shared.spring.httpclient.factory.HttpClientFactoryBean {

    /**
     * Constructor.
     *
     */
    public HttpClientFactoryBean() {
        final StringBuilder stringBuilder = new StringBuilder("Shibboleth/");
        stringBuilder.append(Version.getVersion())
            .append(" OpenSAML/")
            .append(org.opensaml.core.Version.getVersion());
        setUserAgent(stringBuilder.toString());
    }
    
}